///******************************************************************
//
// Moudle Name  :   mtn_lib20_ext.h
// Abstract     :   GaoChuan Motion 2.0 external user header 
// Note :			1.ṹ嶨еġreservedxxxĳԱǱ,Ϊּ,Ϊ0
//					2.ر˵,APIRTN_CMD_SUCCESS0ֵʾִгɹ,ʾ
//					3.еAPI,ر˵,axisHandleʾľ,devHandleʾĿľ,crdHandleʾĿϵ
//                  4.mtn_lib20еĽṹ嶼ֽڶ뷽ʽ룬Ϊ˱ṹ⣬뽫뻷Ϊֽڶ
// Modification History :
///******************************************************************
#ifndef _H_MTN_LIB20_EXT_H_
#define _H_MTN_LIB20_EXT_H_
#include "mtn_lib20.h"

#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------------------------------------
//
//           ָ
//
//------------------------------------------------------------------------------------------------------------
//	1.豸߼õ
//	2.öȡ
//	3.߼ָ
//	4.߼ָ
//	5.Ӳ񼰲ָ
//	6.ƽָ̨
//	7.ݲɼģ(߼ָ)
//	8.
//	9.
//  10.ͨѶչ
//  11.
//  12.PT
//  13.ԾλñȽ
//  14.άλõȽ
//  15.άλñȽ
//  16.ϵת
//  17.ṹʼϰָ
//  18.ջ
//  19.߼BufIoü
//  20.ģ
//  21.scara
//  22.ϵ汣ָ
//  23.ָ
//  24.Զ״̬
///////////////////////////////////////////////////////////////////ָ
//------------------------------------------------------------------------------------------------------------
//
//	1.豸߼õ
//
//------------------------------------------------------------------------------------------------------------

// ͨѶ
// devHandle : 豸
// waitTimeInUsȴʱ,΢
// retryTimes ͨѶԴ
MTN_API short __stdcall NMC_SetCommPara( HAND devHandle, UInt32  waitTimeInUs, UInt32  retryTimes );

// 忨򿪣ƣ
// idStr: 忨IDַ, ָͨд롣pDevHandle: 豸
// עIDûд,粻ʧ,ְ忨忨IDΪ0
MTN_API short __stdcall NMC_DevOpenByID   ( char *idStr, PHAND pDevHandle );

// 忨򿪣IPַ
// pIPv4Array: 忨IPַ,ĸֽ,磺unsinged char ipv4[4] = {192,168,1,110};
// pDevHandle: 豸
MTN_API short __stdcall NMC_DevOpenByIP   (unsigned char *pIPv4Array, PHAND pDevHandle );

// ޸İ忨ID
// pIdStr: Ҫдİ忨IDַ,16ֽ,\0β
// ע޸IDɺ,忨Ҫ,µIDЧ
MTN_API short __stdcall NMC_DevWriteID   ( HAND devHandle, char *pIdStr );

// ȡ忨ID
// pIdStr: 洢ַ,鳤ȴ16ֽ
MTN_API short __stdcall NMC_DevReadID(HAND devHandle, char *pIdStr );

// ȡİ汾
// pVersionհ汾Ϣ
// example(c):
//          char dllVersion[128];
//          NMC_GetDllVersion(dllVersion);
MTN_API short  __stdcall NMC_GetDllVersion(char *pVersion);

// ǰ˶̼İ汾Ϣ
typedef struct
{
	char strVer[16];
	char strOemVer[16];
	char strBuild[32];
}TMtLibVersion;
// ȡǰ˶̼İ汾Ϣ
// devHandle : 豸
// pVersion汾Ϣ
MTN_API short __stdcall NMC_GetMtLibVersion ( HAND devHandle, TMtLibVersion *pVersion );

typedef struct
{
	char strVer[16];           // 汾
	char strOemVer[16];        // OEM汾(ƿ),ĬΪ0
	short time[6];          // ʱ,,ʱ
	short axisNum;          // ֵ֧
	short encNum;           // ֵ֧ı
	short diNum;            // 
	short doNum;            // 
	short daNum;            // ģͨ
	short adNum;            // ģͨ
	short shioNum;          // ͬIOͨ
    short reserved;         // 
	char ipv4[4];           // IPַ
	char idStr[16];         // 忨,࿨ʱƴ򿪲οNMC_DevOpenByID
	UInt32  uid[4];   // Ψһк
}TCardInfo;
// ȡǰ˶Ϣ
MTN_API short __stdcall NMC_GetCardInfo ( HAND devHandle, TCardInfo *pInfo );

// ָ
// enable:0رյϢ,ĬϹر,1:ͨѶdebug2:ӡļ3ӡGCS
// debugOutputFile:ļenable=2ʱҪ
MTN_API short  __stdcall NMC_SetCmdDebug( short enable,char *debugOutputFile);

// ȡϢ
// errCode:
// errDesc:صĴ
MTN_API short  __stdcall NMC_GetErrDesc( short errCode,char *errDesc);

// ļ
MTN_API short __stdcall NMC_LoadConfigFromFile(HAND devHandle, char *pFilePath);

// Ϊļ
MTN_API short __stdcall NMC_SaveConfigToFile(HAND devHandle, char *pFilePath);

// Ϣ,ЩϢ浽ϵͳ,NMC_DevReset,ϵͳʹЩ
// Ĳλ巽ʽʽȫ˲
// enable:1ʾ浱ǰ,ʹԶز,0ʾرԶز
MTN_API short __stdcall NMC_SaveMotionConfig(HAND devHandle,short enable);

// ÿĹ滮ڣĬ1000
// periodλus	ֻΪ250 500 1000
// ע⣺1.滮úЧֻڿʱ
//       2.NMC_DevResetḴλ滮ΪĬֵ
MTN_API short __stdcall NMC_SetProfilePeriod(HAND devHandle,short period);

// ȡĹ滮
// periodλus	ֻΪ250 500 1000
MTN_API short __stdcall NMC_GetProfilePeriod(HAND devHandle,short *pPeriod);
//------------------------------------------------------------------------------------------------------------
//
//	2.öд
//
//------------------------------------------------------------------------------------------------------------
// ȡ滮ģʽ
// pMode˶ģʽ
MTN_API short __stdcall NMC_MtGetPrfMode(HAND axisHandle,short *pMode);

// ȡPtp
// pAxPara
MTN_API short __stdcall NMC_MtGetPtpPara( HAND axisHandle, TPtpPara *pAxPara );

// ȡJog
// pAxPara
MTN_API short __stdcall NMC_MtGetJogPara   ( HAND axisHandle, TJogPara *pAxPara );

// ȡĿ˶ٶ
// pVel: Ŀٶȣٶȣ,λ /ms
MTN_API short __stdcall NMC_MtGetVel( HAND axisHandle, double *pVel );

// ȡĿ˶λ,ֻPTP
// pPos: Ŀλ,λ 
MTN_API short __stdcall NMC_MtGetPtpTgtPos( HAND axisHandle, Int32 *pPos );

// ͨλ
// devHandle : 
// encId: ID,ȡֵΧ[0,n]
// pPos:رֵ
MTN_API short  __stdcall NMC_GetEncPos( HAND devHandle, short encId, Int32 *pPos );

// дͨλ
// devHandle : 
// encId: ID,ͨ,ȡֵΧ[0,n]
//				  չͨ,256ʾһչͨ,257ʾڶ,Դ
// encPos:ֵ
MTN_API short  __stdcall NMC_SetEncPos( HAND devHandle, short encId, Int32 encPos );

// λ,λ趨ֵʱ,ֹͣ˶,ʾλ
// posErrΪ0ʾ
MTN_API short  __stdcall NMC_MtSetPosErrLmt( HAND axisHandle, Int32 posErr );

// ȡλ趨ֵ
MTN_API short  __stdcall NMC_MtGetPosErrLmt( HAND axisHandle, Int32 *pPosErr );

// ȡģʽ
// encId: ID,ͨ,ȡֵΧ[0,n]
//				  չͨ,256ʾһչͨ,257ʾڶ,Դ
// encMode:رģʽ,ο궨
MTN_API short  __stdcall NMC_GetEncMode (HAND devHandle, short encId,  short *encMode );

// ȡλǷֹͣ˶
// posEnλ,1Ϊ,0Ϊֹ
// negEn: λ
MTN_API short  __stdcall NMC_MtGetLmtOnOff    ( HAND axisHandle, short *pPosSwt, short *pNegSwt );

// ȡλشƽ
// posSwtλƽ,1Ϊߵƽ,0Ϊ͵ƽ
// negSwt: λƽ
MTN_API short  __stdcall NMC_MtGetLmtSns      ( HAND axisHandle, short *pPosSwt, short *pNegSwt );

// ȡŷǷֹͣ˶
// swtŷ,1Ϊ,0ΪֹĬΪߵƽ
MTN_API short  __stdcall NMC_MtGetAlarmOnOff  ( HAND axisHandle, short *pSwt );

// ȡŷصƽ
// swtŷƽ,1Ϊߵƽ,0Ϊ͵ƽ
MTN_API short  __stdcall NMC_MtGetAlarmSns    ( HAND axisHandle, short *pSwt );

// ȡλǷֹͣ˶
// enableλ,1Ϊ,0Ϊֹ
MTN_API short  __stdcall NMC_MtGetSwLmtOnOff  ( HAND axisHandle, short *pSwt );

// ȡλֵ
// posLmtλֵ
// negLmtλֵλΪ
MTN_API short  __stdcall NMC_MtGetSwLmtValue  ( HAND axisHandle, Int32 *pPosLmt,Int32 *pNegLmt );

//  ȡᰲȫ
MTN_API short  __stdcall NMC_MtGetSafePara( HAND axisHandle, TSafePara *pPara );

// ȡģʽ
// pInv, 1ȡ,0ȡ
// pMode 0巽 1
MTN_API short  __stdcall NMC_MtGetStepMode ( HAND axisHandle, short *pInv, short *pMode );

// ȡٶ˲
MTN_API short __stdcall NMC_MtGetAxisVelFilter(HAND axisHandle,short *pFilterCoef);

// ȡ
// pHomePara: ṹ,οṹ
MTN_API short __stdcall NMC_MtGetHomePara( HAND axisHandle, THomeSetting *pHomePara );

//------------------------------------------------------------------------------------------------------------
//
//	3.߼ָ
//
//------------------------------------------------------------------------------------------------------------

// ȡеλ
// pPos : λ,λ 
MTN_API short __stdcall NMC_MtGetAxisPos   ( HAND axisHandle, Int32 *pPos );

// ͵ִλ
// pPos : λ,λ 
MTN_API short __stdcall NMC_MtGetCmdPos   ( HAND axisHandle, Int32 *pPos );

// 趨еλ, ᾲֹʱִ,updateָ,Ҫʱһ
// axisPos: 趨еλֵ
// עֻᾲֹʱʹ
MTN_API short  __stdcall NMC_MtSetAxisPos( HAND axisHandle, Int32 axisPos);

// 趨λ, ᾲֹʱִ,updateָ,Ҫʱһ
// encPos: 趨λֵ
// עֻᾲֹʱʹ
MTN_API short  __stdcall NMC_MtSetEncPos( HAND axisHandle, Int32 encPos);

// õ滮߼
// axisHandle : 
// mapAxisNo,ȡֵΧ[0,n]
// port˿ں,ȡֵΧ[0,1],ĬΪ0
// startPosƫ,ĬΪ0
// pCrdHandleϵ
MTN_API short __stdcall NMC_MtPrfConfig(HAND axisHandle,short mapAxisNo,short port,Int32 startPos);

// ȡ滮߼
MTN_API short __stdcall NMC_MtGetPrfConfig(HAND axisHandle,short *mapAxisNo,short *port,Int32 *startPos);

// õϵ
// axisHandle : 
// inCoeϵ,ȡֵΧ(0,1]
MTN_API short __stdcall NMC_MtSetPrfCoe(HAND axisHandle,double inCoe);

// ȡϵ
// axisHandle : 
// pInCoeϵ,ȡֵΧ(0,1]
MTN_API short __stdcall NMC_MtGetPrfCoe(HAND axisHandle,double *pInCoe);

// ͨϵ,ĬΪ1
// axisHandle : 
// encCoeͨϵ,ȡֵΧ(0,1]
MTN_API short __stdcall NMC_MtSetEncCoe(HAND axisHandle,double encCoe);

// ȡͨϵ
// axisHandle : 
// pEncCoeϵ,ȡֵΧ(0,1]
MTN_API short __stdcall NMC_MtGetEncCoe(HAND axisHandle,double *pEncCoe);

// ĵλ
// axisHandle : 
// arrivalBand: λ,λPulse ȡֵ0
// stableTime: λʱ,λ ms ȡֵ0
MTN_API short __stdcall NMC_MtSetAxisArrivalPara(HAND axisHandle,Int32 arrivalBand,Int32 stableTime);

// ȡĵλ
// axisHandle : 
// pArrivalBand:λ,λPulse 
// pStableTimeλʱ,λ ms
MTN_API short __stdcall NMC_MtGetAxisArrivalPara(HAND axisHandle,Int32 *pArrivalBand,Int32 *pStableTime);

// ݾ
// numĶ,ȡֵΧ[2,128]
// startPosʼλãֹλΪ startPos + cmpLen
// cmpLen:
// pCompPos:򲹳ֵ
// pCompNeg:򲹳ֵ
MTN_API short  __stdcall NMC_MtSetLeadScrewCompPara(HAND axisHandle,short num,
						Int32 startPos,Int32 cmpLen,short *pCompPos,short *pCompNeg);

// ʹֹܻݾλò
MTN_API short __stdcall NMC_MtEnableLeadScrew(HAND axisHandle, short enable);

// ÷϶
// compValue 
// compDelta ڲ粹Ϊ100ڲΪ10򲹳10滮100Ĳ
// compDir	 ,0:򲹳1򲹳
MTN_API short  __stdcall NMC_MtSetBacklash(HAND axisHandle, Int32 compValue,double compDelta,Int32 compDir);

// ȡ϶
MTN_API short  __stdcall NMC_MtGetBacklash(HAND axisHandle,Int32 *pCompValue,double *pCompDelta,Int32 *pCompDir);

// õἱͣDI
// gpiIndexͨ,[0,]Ϊ-1ʾȡͣDI
// sense :ƽ,0͵ƽ,1ߵƽ
MTN_API short __stdcall NMC_MtSetEstopDI( HAND axisHandle, short gpiIndex,short sense);

// ȡἱͣDI
// gpiIndexͨ,[0,]
// sense :ƽ,0͵ƽ,1ߵƽ
MTN_API short __stdcall NMC_MtGetEstopDI( HAND axisHandle, short *gpiIndex,short *sense);

// ߼ͨĿ
#define CAPT_EX_CH_NUM				6   // 

// Դ
#define CAPT_EX_SRC_GPI				0   // ͨ
#define CAPT_EX_SRC_NEGLMT          1   // λ
#define CAPT_EX_SRC_POSLMT          2   // λ
#define CAPT_EX_SRC_HOME			3   // ԭ
#define CAPT_EX_SRC_Z				4   // Zź
#define CAPT_EX_SRC_PRFPOS          5   // 滮λã滮λôﵽ趨ֵʱ
#define CAPT_EX_SRC_ENCPOS          6   // λ

typedef struct
{
	short capPosIndex;	// λԴ,0~N1~N+1Ĭ0עıλøûõıģʽ 
	
	short trigSrc;		// Դ,Ķ塣ĬϣCAPT_EX_SRC_GPI
	short trigIndex;	// ԴšĬ0
	short filter;		// ˲ʱ䳣,λ0.1,ȡֵΧ[0,255]
	Int32  trigValue;	// ֵ,ڴԴΪIO,ʾźŴЧƽڴԴΪλ,ʾλáĬ0
}TAdvCaptureParam;

// ø߼,
// pParam:
// ch߼ͨ,[0~3]
MTN_API short __stdcall NMC_MtSetAdvCaptParam( HAND devHandle, TAdvCaptureParam *pParam,short ch);

// ߼״̬,ȡͨĲ
// ch߼ͨ,[0~3]
MTN_API short __stdcall NMC_MtClrAdvCaptSts( HAND devHandle,short ch);

// ȡ߼״̬
// captSts:״̬,bit0ʾõźǰش,bit1ʾźŵĺش
// pPosArray : λ,ڴʱ,λΪ񵽵λֵ
//				pPosArray[0]:źǰشλ,pPosArray[1]:źźشλ,λ:
MTN_API short  __stdcall NMC_MtGetAdvCaptPos( HAND devHandle, short *captSts,Int32 *pPosArray ,short ch);

//------------------------------------------------------------------------------------------------------------
//
//	4.߼ָ
//
//------------------------------------------------------------------------------------------------------------

typedef struct
{
	short lookAheadSwitch;			// ǰհܿƣ0:Ҫǰհ1:ʹλǰհ[2,n]ʹλǰհֵΪǰհ
	short centAccEn;				// ǷʹָļٶȣĬΪ0ʹ
	short crossEn;					// ߶κϲ,0:رպϲ1úϲ
	short eventTime;				// Сٶʱ,λms,(ĬΪ10)

	double accMax;					// ̨ٶ,Ĭ1000
	double T;						// ǰհʱ䳣,Խٶȱ仯ԽС (Ĭ1)
	double slowAng;					// ٽǶ,С趨Ƕȣ򲻼
	double stopAng;					// ֹͣǶȣ趨ǶȣΪ0
	double crossProp;				// ߶κϲȣȡֵΧ(0,n]	
	double centAcc;					// ļٶ
	double dvMax[CRD_MAX_DIMENSION];// ٶȱ仯

	short preHandleEn;				// 켣Ԥܿ
	short reserved;					// 
	float preHandleDisAngMin;		// 켣ԤСǶȣ
	float preHandleDisAngMax;		// 켣ԤǶ
	float preHandleTol;				// Ԥλ:

}TLookaheadPara;

// ϵ˶չ
typedef struct
{
	double startVel;					//ٶȣĬ0
	double T;							//ǰհʱ䳣,Խٶȱ仯ԽС (Ĭ1)
	double smoothDec;					//ֹͣٶȣĬaccMax
	double abruptDec;					//ͣٶȣĬ
	short  lookAheadSwitch;				//ǰհ( ĬΪ1ʾǰհ)
	short eventTime;					// Сٶʱ,λms,(ĬΪ10)
	short reserved[2];
}TExtCrdPara;
// ϵչ 
// extCrdPara:ϵչ,οϵ˶չTExtCrdParaṹ嶨
MTN_API short __stdcall NMC_CrdSetExtPara( HAND crdHandle, TExtCrdPara *extCrdPara);

// ϵ˶Ƿ,NMC_CrdConfigĬΪ״̬
// enFlag:,1,0
// ע⣺ʹϵ˶,NMC_CrdConfig֮øָ
MTN_API short __stdcall NMC_EnableCrdSdram( HAND crdHandle, short enFlag);

// ȡϵչ
// extCrdPara:ϵչ
MTN_API short __stdcall NMC_CrdGetExtPara( HAND crdHandle, TExtCrdPara *extCrdPara);
 
// ϵ˶Բ岹
#define MAX_ERR_TABLE_SECTION	2
typedef struct
{
	double minSectionLen;				// ֽСγ,Ĭ1,Χ[1,10000]
	double maxArcDiff;					// ԲЧ,λ
		
	// Բ岹ñ
	// ע⣺MTNͨԲ岹ٶ,Ӷ֤岹rȫΪ0,ʾر
	double r[MAX_ERR_TABLE_SECTION];	// 뾶
	double err[MAX_ERR_TABLE_SECTION+1];	// 뾶ӦĲ岹,뾶 [0,r0],Ӧerr0;뾶[r0,r1],Ӧerr1;뾶[r1,+max],Ӧerr2

}TArcSecSetting;
// Բ岹߼ָ
// pSetting : 
MTN_API short __stdcall NMC_CrdSetArcSecPara( HAND crdHandle,  TArcSecSetting *pSetting);
                                          
// Բ岹߼ָ
MTN_API short __stdcall NMC_CrdGetArcSecPara( HAND crdHandle,  TArcSecSetting *pSetting);

// ϵ˶
typedef struct
{
	short orgFlag;		// ǷԶϵԭ
	short reserved[3];		// 
	Int32 offset[4];		// Զϵԭƫãڻеԭ㣩
	double synAccMax;	// ϳɼٶ
	double synVelMax;	// ϳٶ
}TCrdPara;
// ϵ()
// pCrdPara:ϵ
MTN_API short __stdcall NMC_CrdSetPara( HAND crdHandle, TCrdPara *pCrdPara );

// ȡ岹ϵϵͳϢ
// pConfig:ϵ,οṹ嶨
MTN_API short __stdcall NMC_CrdGetConfig( HAND crdHandle, TCrdConfig *pConfig );

// ȡϵ
// pCrdPara:ϵ
MTN_API short __stdcall NMC_CrdGetPara( HAND crdHandle, TCrdPara *pCrdPara );

// ȡϵٶȱ
// overRideϵٶȱ
MTN_API short __stdcall NMC_CrdGetOverRide( HAND crdHandle, double *pOverRide );

// ϵ״̬λ:ڲչ 
#define BIT_CORD_POSREC         (0x00000040)    // bit 6 , ŷλõ,ģʽʱλõ,ŷģʽʱʵλõ    
#define BIT_CORD_AUXAXIS_BUSY   (0x00000080)    // bit 7 , ϵ˶еĹǰ˶״̬
#define BIT_CORD_AUXAXIS_ERR    (0x00000100)    // bit 8 , 岹             
#define BIT_CORD_AXIS_ERR       (0x00000200)    // bit 9 , 岹ڱλ   
#define BIT_CORD_SDRAM_CALC_ERR (0x00000400)    // bit 10 , SDRAM  
#define BIT_CORD_SCARA_CALC_ERR (0x00000800)    // bit 11 , SCARAݴ
// ȡڲϵ״̬
// pStsWord״̬,64bits(άInt32 ),ںչ״̬λ
MTN_API short __stdcall NMC_CrdGetInnerSts     ( HAND crdHandle, Int32 *pStsWord );

// ֱ޸ϵƫ
// pOffsetArray:ϵƫ
// cnt:鳤
MTN_API short __stdcall NMC_CrdModifyOffset( HAND crdHandle, Int32 *pOffsetArray, short cnt);

// üͣDI
// axis:,ȡֵΧ[0,n)
// gpiIndex:ͨ
// sense:ƽ
MTN_API short  __stdcall NMC_CrdBufSetEstopDI ( HAND crdHandle,Int32 segNo,short axis,short gpiIndex,short sense);

// ݴ
#define BUF_LINE	0 //ֱ߲岹
#define BUF_DO		1 //DO
#define BUF_OUT		2 //OUT
#define BUF_DELAY   3 //ʱ
#define BUF_AXMOVE	4 //˶
#define BUF_DOEX    5 //DO
#define BUF_ARC_R   6 //ƽԲ岹յλá뾶
#define BUF_ARC_C   7 //ƽԲ岹յλáԲġ
#define BUF_LASER_SETPOWER		8	// ⣺
#define BUF_LASER_ONOFF			9	// ⣺ع
#define BUF_LASER_SETFOLLOW		10	// ⣺ø
#define BUF_LASER_SETPARAM		11	// ⣺ò
#define BUF_LINEXYZA			12	// ֱ߲岹
#define BUF_SHIO_GATEPULSE		13	// Gate
#define BUF_DOBITPULSE			14	// DoBitPulse
#define BUF_XYZD8          		15	// LineXYZD8,ݽṹΪTCrdLineXYZD8Unit
#define BUF_SHIOMINFRQ     		16	// ûSHIOСƵ
#define BUF_SHIOSETPARAM        17	// SHIO
#define BUF_SHIOGATEONOFF       18	// Gate
#define BUF_WAITENCINPOS        19	// ȴλ
#define BUF_WAITDI              20	// ȴDI

#pragma pack(push)
#pragma pack(4)
typedef struct
{  
	Int32 segNo;        // ûԶκ
	Int32 tgPos[3];     // Ŀλ
	double endVel;     // յٶ
	double vel;        // ٶ
	double synAcc;     // 岹ٶ
	short mask;        // ,λʾ
	short lookaheadDis;//Ƿʹǰհ
    Int32  reserved;     // 
}TCrdBufLine;

typedef struct
{  
	Int32 tgPos[4];     // Ŀλ
	double endVel;     // յٶ
	double vel;        // ٶ
	double synAcc;     // 岹ٶ
	Int32 segNo;        // ûԶκ
	short mask;        // ,λʾ
	short lookaheadDis;//Ƿʹǰհ
}TCrdBufLineXYZA;

typedef struct
{
	Int32 segNo;     // ûԶκ
	short group;    // Out 
	short ch;       // ͨ,ȡֵΧ[0,n]
	Int32 outValue;	// 
}TCrdBufOut;

typedef struct
{
	Int32 segNo;     // ûԶκ
	short group;    // DO 
	short ch;       // λ,ȡֵΧ[0,31]
	Int32 value;     // ֵ,ȡֵΧ[0,1]
}TCrdBufDO;

typedef struct
{
	Int32 segNo;     // ûԶκ
	Int32 scale;     // ʱλ,0ʾλΪ,1ʾλΪ
	Int32 count;     // ʱʱ
}TCrdBufDelay;

typedef struct
{
	Int32 segNo;     // ûԶκ
	Int32 group;    // DO
	Int32 doMask;    // λ,bitλΪ1ʾҪ
	Int32 value;     // ֵ,bitλָʾֵ
}TCrdBufDOEx;

typedef struct
{
	Int32 segNo;         // ûԶκ
	short axis;		    // ƶ [0,n],ϵ	
	short soomthCoef;   // smoothCoef:ƽϵ
	short blockEn;      // ǷΪģʽ 0  ,1 
	short synEn;        // ǷΪͬģʽ 0 첽 ,1 ͬ
    Int32  tgPos;	    // Ŀλ
	double vel;         // ˶ٶ
	double acc;         // ˶ٶ
}TCrdBufAxMove;

typedef struct
{
	Int32 segNo;         // ûԶκ
	Int32 tgPos[2];		// Ŀλ
	short circleDir;    // ǷΪͬģʽ 0 첽 ,1 ͬ
	char lookaheadDis;	// Ƿʹǰհ
	char panelIndex;	// Բ岹ƽ棺0XYƽ棬1YZƽ棬ZXƽ
	double radius;		// 뾶
	double endVel;      // յٶ
	double vel;         // ˶ٶ
	double acc;         // ˶ٶ
}TCrdBufArcR;

typedef struct
{
	Int32 segNo;         // ûԶκ
	Int32 tgPos[2];		// Ŀλ
	Int32 centerPos[2];	// Ŀλ
	short circleDir;    // ǷΪͬģʽ 0 첽 ,1 ͬ
	char lookaheadDis;	// Ƿʹǰհ
	char panelIndex;	// Բ岹ƽ棺0XYƽ棬1YZƽ棬ZXƽ
	double endVel;      // յٶ
	double vel;         // ˶ٶ
	double acc;         // ˶ٶ
}TCrdBufArcC;
 
typedef struct
{  
	Int32 segNo;        // ûԶκ
	Int32 onDelay;     // ʱ
	Int32 offDelay;     // عʱ
	Int32 minValue;     // Сֵ
	Int32 maxValue;     // ֵ
	Int32 standbyPower;	// 
	short ch;			// ͨ
	short reserved;		// 
}TCrdBufLaserSetParam;

typedef struct
{  
	Int32 segNo;        // ûԶκ
	short followType;    // 
	short ch;			// ͨ
	double overRide;     // 汶
}TCrdBufLaserSetFollow;

typedef struct
{  
	Int32 segNo;        // ûԶκ
	short onOff;		// ,0ع,1
	short ch;			// ͨ
}TCrdBufLaserOnOff;

typedef struct
{  
	Int32 segNo;        // ûԶκ
	short ch;			// ͨ
	short reserved;		// 
	double power;		// 
}TCrdBufLaserSetPower;

typedef struct
{  
	Int32 segNo;        // ûԶκ
	Int32 outCount;		// 
	double gateTime;	// gateλ΢
	double gateFrq;		// gateƵʣλHZ
	short ch;			// ch:ͨ
    short reserved[3];  // 
}TCrdBufSHIOGatePulse;


typedef struct
{  
	Int32 segNo;			// ûԶκ
	Int32 highLevelTime;	// ߵƽȣλ:us
	Int32 lowLevelTime;	// ͵ƽȣλ:us
	Int32 outCount;		// 
	Int32 initialLevel;	// 0͵ƽ1ߵƽ
	short ch;			// ch:ͨ
	short enable;		// 1:ʹ,0:ر
	short doType;		// DO,ĬCRD_BUFF_DO_GPDO1
	short doIndex;		// DOţȡֵΧ[0,n]
}TCrdBufDoBitPulse;

typedef struct
{  
	Int32 segNo;			// ûԶκ
    Int32 minFrq;        // СƵʣenable=1ʱЧ
	short ch;			// ͨ
	short setOrClr;		// 1:,0:
}TCrdBufSHIOMinFrq;

typedef struct
{  
	Int32 segNo;			// ûԶκ
	short ch;			// ͨ
	short reserved;		// 
    double delay;       // ʱعʱ
    double gateTime;    // gateʱ䣬λ:
    double gateDistance;// ̶ģʽµλüλpulse
}TCrdBufSHIOSetParam;

typedef struct
{  
	Int32 segNo;			// ûԶκ
	short ch;			// ͨ
	short onOff;		// 1:򿪣0ر
}TCrdBufSHIOGateOnOff;

typedef struct
{  
	Int32 segNo;			// ûԶκ
	Int32 axisMask;		// 
	Int32 overTime;		// ȴʱʱ䣬λ
}TCrdBufWaitEncInPosition;

typedef struct
{  
	Int32 segNo;			// ûԶκ
	short index;		// ͨ,ȡֵΧ[0,127],ǰ64ͨͨDI64ͨչIO
	short level;		// ȴֵ
    Int32 waitLastTime;  //ʱ,λ
}TCrdBufWaitDI;

#pragma pack(pop)

// 岹
// pBufData 岹ݽṹ洢
// dataLen ݳ
// ѹʱѹָ֣ȻѹֶָӦĹݣܵݳȲ1000ֽ
MTN_API short __stdcall NMC_CrdBufDataPack(HAND crdHandle,  unsigned char *pBufData, short dataLen);

//ܣ̽λֹͣλƫ
// useCaptPosǷʹòλ  1ʹ,0ʹ
// axis:
// sense:ƽ,0͵ƽ,1ߵƽ
// gpiIndex:ͨ
MTN_API short  __stdcall NMC_CrdBufSetStopOffset ( HAND crdHandle, Int32 segNo,
	short axis,short gpiIndex,short sense,short useCaptPos);

//ܣ̽λֹͣλƫ
MTN_API short  __stdcall NMC_CrdBufClrStopOffset ( HAND crdHandle, Int32 segNo,short axis);

// Ƿ߶γ
MTN_API short __stdcall NMC_CrdSetBufLengthFlag(HAND crdHandle, short flag);

// ȡ岹߶γ
MTN_API short __stdcall NMC_CrdGetBufLength(HAND crdHandle, double *pLen);

MTN_API short  __stdcall NMC_CrdSetIsShortLine(HAND crdHandle,short isShortLine);

MTN_API short  __stdcall NMC_CrdSetLookAheadCentriAcc(HAND crdHandle,short isUsingSetAcc,double centriAcc);

//------------------------------------------------------------------------------------------------------------
//
//	5.Ӳ񼰲ָ
//
//------------------------------------------------------------------------------------------------------------

// Ӳģʽѡ 
#define CAPT_MODE_Z          0   // Zಶ 
#define CAPT_MODE_IO         1   // IO  
#define CAPT_MODE_Z_AND_IO   2   // IO+Z  
#define CAPT_MODE_Z_AFT_IO   3   // IOZഥ  

// ӲIOԴѡ 
#define CAPT_IO_SRC_HOME    0   // ԭΪIO 
#define CAPT_IO_SRC_LMTN    1   // λΪIO 
#define CAPT_IO_SRC_LMTP    2   // λΪIO 
#define CAPT_IO_SRC_DI0     3   // ͨ0ΪIO 
#define CAPT_IO_SRC_DI1     4   // ͨ1ΪIO 
#define CAPT_IO_SRC_DI2     5   // ͨ2ΪIO 
#define CAPT_IO_SRC_DI3     6   // ͨ3ΪIO 
#define CAPT_IO_SRC_DI4     7   // ͨ4ΪIO 
#define CAPT_IO_SRC_DI5     8   // ͨ5ΪIO 
#define CAPT_IO_SRC_DI6     9   // ͨ6ΪIO 
#define CAPT_IO_SRC_DI7     10  // ͨ7ΪIO 
#define CAPT_IO_SRC_DI8     11  // ͨ8ΪIO 
#define CAPT_IO_SRC_DI9     12  // ͨ9ΪIO 
#define CAPT_IO_SRC_DI10    13  // ͨ10ΪIO 
#define CAPT_IO_SRC_DI11    14  // ͨ11ΪIO 
#define CAPT_IO_SRC_DI12    15  // ͨ12ΪIO 
// òЧƽ
// mode : ģʽѡ,ο궨
// ioSrcIOԴѡ,ο궨
// level: ءbit0:indexƽ0Ϊ½,1Ϊأ,bit1:IOƽ
MTN_API short  __stdcall NMC_MtSetCaptSns( HAND axisHandle, short mode, short ioSrc, short level );

// ȡЧƽ
// mode : ģʽѡ,ο궨
// ioSrcIOԴѡ,ο궨
// level: ء0Ϊ½,1Ϊ
MTN_API short  __stdcall NMC_MtGetCaptSns( HAND axisHandle, short *pMode, short *pIoSrc, short *pLevel );

// 
// ע񴥷־״̬
MTN_API short  __stdcall NMC_MtSetCapt( HAND axisHandle );

// Ĳ״̬
MTN_API short __stdcall NMC_MtClrCaptSts   ( HAND axisHandle);

// λ
// pPos : λ,λ:
MTN_API short  __stdcall NMC_MtGetCaptPos( HAND axisHandle, Int32 *pPos );

// ȡ˲
// pCoeϵ Χ0~65535,0˲,ֵԽ˲ЧԽԡĬֵΪ0
MTN_API short  __stdcall NMC_MtGetStepFilter ( HAND axisHandle, unsigned short  *pCoe );

// ͬʱ
// axisHandle:
// maskbitӦӦ,bitΪ1ʾ,bitΪ0ʾ
MTN_API short __stdcall NMC_MtUpdateMulti( HAND axisHandle,Int32 mask );

// ͬʱֹͣ
// axisHandle:
// maskbitӦӦ,bitΪ1ʾ,bitΪ0ʾ
MTN_API short __stdcall NMC_MtStopMulti( HAND axisHandle,Int32 mask  );

// λͨźȡ
// bitIndex:ȡֵΧ[0,n],λ,ǰ64λΪصͨ,64ΪչDi
// revs:Ƿȡ,1ȡ,0ȡ
MTN_API short  __stdcall NMC_SetDIBitRevs ( HAND devHandle,short bitIndex,short revs);

// λȡͨźȡ
// bitIndex:ȡֵΧ[0,n],λ,ǰ64λΪصͨ,64ΪչDi
// pRevs:Ƿȡ,1ȡ,0ȡ
MTN_API short  __stdcall NMC_GetDIBitRevs ( HAND devHandle,short bitIndex,short *pRevs);

// λͨźȡ
// bitIndex:ȡֵΧ[0,n],λ,ǰ64λΪصͨ,64ΪչDo
// revs:Ƿȡ,1ȡ,0ȡ
MTN_API short  __stdcall NMC_SetDOBitRevs ( HAND devHandle,short bitIndex,short revs);

// λȡͨźȡ
// bitIndex:ȡֵΧ[0,n],λ,ǰ64λΪصͨ,64ΪչDo
// pRevs:Ƿȡ,1ȡ,0ȡ
MTN_API short  __stdcall NMC_GetDOBitRevs ( HAND devHandle,short bitIndex,short *pRevs);

// DOʱ
// bitIndex:ȡֵΧ[0,n],λ,ǰ64λΪصͨ,64ΪչDo
// value:ͨ1, ߵƽ,0,͵ƽ
// reverseTime:ĵƽ,λ:
MTN_API short  __stdcall NMC_SetDOBitAutoReverse(HAND devHandle,short bitIndex,short value,short reverseTime);

// DIOӳ
#define DIO_MAP_MAX_NUM		8	// ӳϵ

// źͶ
#define DIO_TYPE_GPI		1	// ͨ
#define DIO_TYPE_HOME		2	// Homeź
#define DIO_TYPE_ALM		3	// ź
#define DIO_TYPE_LMTN		4	// Ḻλź
#define DIO_TYPE_LMTP		5	// λź
#define DIO_TYPE_GPO		6	// ͨź
#define DIO_TYPE_SVON		7	// ŷʹź
#define DIO_TYPE_SVCLR		8	// ź


// DIoӳ
typedef struct 
{
	unsigned char  enable;		// 1ã0
	unsigned char  pinGrp;      // ӳź
	unsigned char  pinIndex;    // ӳź
	unsigned char  outEnable;	//        
	unsigned char  newGrp;      // ӳ䵽ź
	unsigned char  newIndex;	// ӳ䵽ź
}TDioMappingCfg;

// һӳ䣬ӳϵĿǰDIO_MAP_MAX_NUM
MTN_API short  __stdcall NMC_SetDioMapping(HAND devHandle,TDioMappingCfg *pDioCfg);

// ȡеDIOӳ
// pDioCfgӳ,ĿǰΪDIO_MAP_MAX_NUM
MTN_API short  __stdcall NMC_GetAllDioMapping(HAND devHandle,TDioMappingCfg *pDioCfg);

// еDIOӳϵ
MTN_API short  __stdcall NMC_ClrAllDioMapping(HAND devHandle);


//------------------------------------------------------------------------------------------------------------
//
//	6.ƽָ̨
//
//------------------------------------------------------------------------------------------------------------
// 
#define     VAR_PWM0_CTL    256		// pwmͨ0򿪹ر,1ʾ,0ʾر
#define     VAR_PWM0_VALUE  257		// pwmͨ0ֵ
#define     VAR_PWM1_CTL    258		// pwmͨ1򿪹ر,1ʾ,0ʾر
#define     VAR_PWM1_VALUE  259		// pwmͨ1ֵ
#define     VAR_EXT_DAC0    260		// չDACͨ0
#define     VAR_EXT_DAC1    261		// չDACͨ1
#define     VAR_OUT_OPTION	262		// PWMͨѡ
#define     VAR_DAC0		263		// DACͨ0~7
#define     VAR_DAC1		264
#define     VAR_DAC2		265
#define     VAR_DAC3		266
#define     VAR_DAC4		267
#define     VAR_DAC5		268
#define     VAR_DAC6		269
#define     VAR_DAC7		270
#define     VAR_ADC0		271		// ADCͨ0~7
#define     VAR_ADC1		272
#define     VAR_ADC2		273
#define     VAR_ADC3		274
#define     VAR_ADC4		275
#define     VAR_ADC5		276
#define     VAR_ADC6		277
#define     VAR_ADC7		278
// ͨÿѰַ 8ֽͣɺǳõ,磺char/short/Int32 /double ȣ
MTN_API short __stdcall NMC_SetVar8B( HAND devHandle, Int32 varID, Int64 value );

// ȡͨÿѰַ 8ֽͣɺǳõ,磺char/short/Int32 /double ȣ
MTN_API short __stdcall NMC_GetVar8B( HAND devHandle, Int32 varID, Int64 *pValue );

// ϵͳ궨
#define SYS_VAR_SET_STAT_ENABLE		100
#define SYS_VAR_GET_CLOCK			101
#define SYS_VAR_GET_USERAPP_COUNT	107
#define SYS_VAR_GET_USERAPP_MIN		108
#define SYS_VAR_GET_USERAPP_MAX		109
#define SYS_VAR_GET_USERAPP_AVG		110
#define SYS_VAR_GET_USERAPP_CURT	111
#define SYS_VAR_GET_PRFINT_COUNT	112
#define SYS_VAR_GET_PRFINT_MIN		113
#define SYS_VAR_GET_PRFINT_MAX		114
#define SYS_VAR_GET_PRFINT_AVG		115
#define SYS_VAR_GET_PRFINT_CURT		116
#define SYS_VAR_GET_MAINLP_COUNT	117
#define SYS_VAR_GET_MAINLP_MIN		118
#define SYS_VAR_GET_MAINLP_MAX		119
#define SYS_VAR_GET_MAINLP_AVG		120
#define SYS_VAR_GET_MAINLP_CURT		121

// ͨÿѰַϵͳ 8ֽͣɺǳõ,磺char/short/Int32 /double ȣ
MTN_API short __stdcall NMC_SysSetVar8B( HAND devHandle, Int32 varID, Int64 value );

// ȡͨÿѰַϵͳ 8ֽͣɺǳõ,磺char/short/Int32 /double ȣ
MTN_API short __stdcall NMC_SysGetVar8B( HAND devHandle, Int32 varID, Int64 *pValue );

//򱸷ڴд(ܳԼ510byte)
//src: Ҫд
//len: Ҫдĳ,λbyte
//off: Ҫдĵַ(ƫ)
// ע1)дݵ粻ʧ
//     2)һд1440ֽڡܳԼ1500byte
MTN_API short __stdcall NMC_BackSramWrite(HAND devHandle,const void *src, Int32 len, Int32 off);

//ӱڴ
//dst: ݴ
//len: Ҫĳ,λbyte,һ1440ֽڡܳԼ1500byte
//off: ݵĵַ(ƫ)
MTN_API short __stdcall NMC_BackSramRead(HAND devHandle,void *dst, Int32 len, Int32 off);

// ƽ̨ʱṹ
typedef    struct
{
    short   year;           // ,ʵݡȡֵΧ[2000,2099]
    short   mon;            // ,ȡֵΧ[1,12]
    short   day;            // ,ȡֵΧ[1,31]
    short   hour;           // ʱ,ȡֵΧ[0,23]
    short   min;            // ,ȡֵΧ[0,59]
    short   second;         // ,ȡֵΧ[0,59]
} TNMCTime;
// ʱ
// pTime ʱṹ,ο TNMCTime ṹ
// עʱڳʱʵʱ趨,ûָͨ޸
MTN_API short  __stdcall NMC_GetTime( HAND devHandle, TNMCTime *pTime );


// дʱ
// pTime ʱṹ,ο TNMCTime ṹ
// pPassword : ϵͳ,Ϊ16ֽ
MTN_API short  __stdcall NMC_SetTime( HAND devHandle, TNMCTime *pTime,char *pPassword);

// ޸Ŀϵͳ,޸ϵͳʱӵ
// pPasswordOld : ϵͳǰ,Ϊ15ַ
// pPasswordNew : µĿϵͳ,Ϊ15ַ
// ע⣺1.ʼ
//            2.޸,ؼסµ롣ֻܷλ
//            3.Сд
MTN_API short  __stdcall NMC_ChangePassword( HAND devHandle, char *pPasswordOld,char *pPasswordNew);

// ֤ϵͳ
// pPassword : ϵͳǰ,Ϊ15ַ
// 0ʾ֤ͨ,ʾ
MTN_API short  __stdcall NMC_VerifyPassword( HAND devHandle, char *pPassword);

// ϵͳ뼰û
// pData:ݣΪ8
MTN_API short  __stdcall NMC_ClrPassword( HAND devHandle, short *pData);

// 豸Ψһк
// pUID 豸Ψһк,ΪĸInt32
// example:UInt32  devID[4];
//         NMC_GetUID(g_hDev,devID);
MTN_API short  __stdcall NMC_GetUID( HAND devHandle, UInt32  *pUID );

// дû
// add ƫƵַ(ֽڵַ)
// len : д볤,λbyte
// pWrData Ҫдݣ
// ע1)дݵ粻ʧ
//     2)һд256ֽڡܳΪ2048ֽڡ
//     3)ָָʱ᳤,ͨѶ󣨷-1,ҪͨNMC_SetCommParaӳָͨѶʱ
MTN_API short  __stdcall NMC_UserParaWr( HAND devHandle, UInt32  add, UInt32  len, unsigned char *pWrData );

// û
// add ƫƵַ(ֽڵַ)
// len : д볤,λbyte
// pRdData Ҫȡݴ洢
// עһ256ֽڡܳΪ2048ֽڡο  NMC_UserParaWr
MTN_API short  __stdcall NMC_UserParaRd( HAND devHandle, UInt32  add, UInt32  len, unsigned char *pRdData );

// дչû
// add ƫƵַ(ֽڵַ)
// len : д볤,λbyte
// pWrData Ҫдݣ
// ע1)дݵ粻ʧ
//     2)һд1000ֽڡܳΪ32Kֽڡ
//     3)ָָʱ᳤,ͨѶ󣨷-1,ҪͨNMC_SetCommParaӳָͨѶʱ
MTN_API short  __stdcall NMC_UserParaWrEx( HAND devHandle, UInt32  add, UInt32  len, unsigned char *pWrData );

// չû
// add ƫƵַ(ֽڵַ)
// len : д볤,λbyte
// pRdData Ҫȡݴ洢
// עһ1000ֽڡܳΪ32Kֽڡο  NMC_UserParaWr
MTN_API short  __stdcall NMC_UserParaRdEx( HAND devHandle, UInt32  add, UInt32  len, unsigned char *pRdData );

// 籣棺ݶ
typedef struct
{
	Int32 crdSegNo;		// ϵ˶Ķκ
	Int32 crdPrfPos[3];	// ϵ˶Ĺ滮λ
	Int32 axPrfPos[8];	// 滮λ
	Int32 axisPos[8];	// еλ
	Int32 encPos[8];		// λ
}TBackGroup1;
// ȡǰݵıֵϵԶ棩
// pBackVar : ݵıֵ,οṹ嶨
MTN_API short __stdcall NMC_GetBackedVarGroup1( HAND devHandle, TBackGroup1 *pBackVar);

// 籣棺ݶ壨12ᣩ
typedef struct
{
	Int32 crdSegNo[2];		// ϵ˶Ķκ
	Int32 crdPrfPos[2][3];	// ϵ˶Ĺ滮λ
	Int32 axPrfPos[12];		// 滮λ
	Int32 axisPos[12];		// еλ
	Int32 encPos[12];		// λ
}TBackGroup2;
// ȡǰݵıֵϵԶ棩
// pBackVar : ݵıֵ,οṹ嶨
MTN_API short __stdcall NMC_GetBackedVarGroup2( HAND devHandle, TBackGroup2 *pBackVar);

// ʼ߹رձԶݣϵԶ,ĬΪر״̬
// en:Ƿ,1Զ,0ֹͣԶ
MTN_API short __stdcall NMC_SetBackedVarOnOff( HAND devHandle, short en);

// ȡǰԶݵĿ״̬
// pEn:ǰĿ״̬
MTN_API short __stdcall NMC_GetBackedVarOnOff( HAND devHandle, short *pEn);

// paraID
#define     PARA_IP_ADDR   	100		// IPַ,ĸֽڷֱʾĶ
#define     PARA_IP_MSK    	101		// IP mask
#define     PARA_IP_GW   	102		// Gateway
#define     PARA_IP_DHCP   	103		// DHCP
#define     PARA_WRITE_EN	999		// 
// ȡϵͳInt32 ͣ
// paraID :ϵͳID,μ涨塣pValue : ֵ
// ע˺ð忨ϵչԴ
MTN_API short  __stdcall NMC_DevGetPara( HAND devHandle, UInt32  paraID, Int32 *pValue );

// ϵͳInt32 ͣ
// paraID :ϵͳID,μ涨塣value : ֵ
// ע˺ڶȡ忨ϵչԴ
// עIPַȲдɹ,ҪNMC_DevSetPara(devHandle,PARA_WRITE_EN,1)ʹдȥĲ
// עIPַȲдɹ,ڿЧ
MTN_API short  __stdcall NMC_DevSetPara( HAND devHandle, UInt32  paraID, Int32 value );

// û
// pUserName    : ָû,Ŀǰֻ֧"USER1"
// pPasswordOld : ûĵǰ,Ϊ15ַ
// pPasswordNew : µĸû,Ϊ15ַ
// ע⣺1.ʼ,һ,Ҫ½,ĳЩָ˶ָ,DOָ
//      2.޸,ؼסµ롣ֻܷλ
//      3.Сд
MTN_API short  __stdcall NMC_UserSetPassword( HAND devHandle, char *pUserName,char *pPasswordOld,char *pPasswordNew);

// û½
// pUserName    : ָû,Ŀǰֻ֧"USER1"
// pPassword    : û
MTN_API short  __stdcall NMC_UserLogin( HAND devHandle, char *pUserName,char *pPassword);

// û˳½
// pUserName    : ָû,Ŀǰֻ֧"USER1"
MTN_API short  __stdcall NMC_UserLogout( HAND devHandle, char *pUserName);

//------------------------------------------------------------------------------------------------------------
//
//	7.ݲɼģ(߼ָ)
//
//------------------------------------------------------------------------------------------------------------

// Collectģ飺
#define COLLECT_ADDRESS_PRF_POS				(0)	// 滮λ
#define COLLECT_ADDRESS_AXIS_POS			(1)	// еλ
#define COLLECT_ADDRESS_ENC_POS				(2)	// λ
#define COLLECT_ADDRESS_CMD_POS				(3)	// λ
#define COLLECT_ADDRESS_AXIS_VEL			(4)	// ٶ
#define COLLECT_ADDRESS_CRD_POS				(5)	// ϵ0λ
#define COLLECT_ADDRESS_CRD_VEL				(6)	// ϵ0ٶ
#define COLLECT_ADDRESS_CRD_POS0			(5)	// ϵ0λ
#define COLLECT_ADDRESS_CRD_VEL0			(6)// ϵ0ٶ
#define COLLECT_ADDRESS_CRD_POS1			(9)// ϵ1λ		
#define COLLECT_ADDRESS_CRD_VEL1			(10)// ϵ1ٶ
#define COLLECT_ADDRESS_ENC_VEL				(7)	// ٶ
#define COLLECT_ADDRESS_CMD_VEL				(8)	// ٶ
#define	COLLECT_ADDRESS_LASER_OUTPUT		(11)// ǰ
#define COLLECT_ADDRESS_LASER_GATE			(12)// gateź״̬
#define COLLECT_ADDRESS_LASER_POWER			(13)// ǰֵ
#define COLLECT_ADDRESS_DI      			(14)// ״̬
#define COLLECT_ADDRESS_DO      			(15)// ״̬
// ȡҪɼݱĵַ
//  index:(0ʼ)
//  type: ,Collectģ飺͡궨
//  pAddr: صݵַ
// pDataLen: صĸݳ
MTN_API short  __stdcall NMC_GetCollectDataAddr( HAND devHandle, short index,short dataType,UInt32  *pAddr, short *pDataLen);

// ɼģ飺ɼ
#define COLLECT_LIST_MAX		(8) 			//ÿɼ8
typedef struct
{
	short  count;								// Ҫɼı
	short  interval;							// ɼļʱ,0ʾÿ1ײɼһ,1ʾÿ2ms...
	UInt32   address[COLLECT_LIST_MAX];	// ĵַ
	short  length[COLLECT_LIST_MAX];			// ÿĳȣλchar
}TCollectCfg;

// ɼģ飺ģʽ
#define COLLECT_MODE_NONE	0	// 
#define COLLECT_MODE_G_SRC1	1	// ɼԴ1ֵڱȽֵ
#define COLLECT_MODE_L_SRC1	2	// ɼԴ1ֵСڱȽֵ
#define COLLECT_MODE_DIFF	3	// ɼԴ1ɼԴ2ֵڱȽֵ
typedef struct
{
	short  mode;								// ģʽ,
	short  source1;								// Դ1
	short  source2;								// Դ2
	short  startDelay;							// ʱ
	double  value;								// Ƚֵ
}TCollectTrig;
// òɼͨ,ҪöӦṹ
// pCollect:ɼģ
// pTrig:ɼģ鴥ʽ
MTN_API short  __stdcall NMC_ConfigCollect( HAND devHandle, TCollectCfg *pCollect,TCollectTrig *pTrig );

// ֹͣݲɼ
// en1 0ֹͣ
MTN_API short  __stdcall NMC_CollectOnOff ( HAND devHandle, short en);

// Collectģ飺ɼ״̬
#define COLLECT_BUSY						(0x0001)
#define COLLECT_OVERRIDE_DATA				(0x0002)	
#define COLLECT_PUSH_DATA_ERR				(0x0004)
// ȡɼ״̬:
// pStsɼ״̬,λʾ״̬,οCollectģ飺ɼ״̬궨
// pDataLen: ɼ
MTN_API short  __stdcall NMC_GetCollectSts ( HAND devHandle, short *pSts, Int32 *pDataLen );

// ȡ:
// lenɼݳȣλchar,һ1440ֽڣ
// pData: ɼݣcharΪԪ洢
MTN_API short  __stdcall NMC_GetCollectData ( HAND devHandle, short len, unsigned char *pData );

// ɼ״̬
MTN_API short  __stdcall NMC_ClearCollectSts ( HAND devHandle);

//------------------------------------------------------------------------------------------------------------
//
//	8.
//
//------------------------------------------------------------------------------------------------------------
#define MAX_LASER_NUMS			    (2)	    // 󼤹ͨ

// ģʽ
#define LASER_DISABLE_MODE			    (0)	    // ü⹦
#define BASIC_OUTPUT_MODE			    (1)		// ģʽ
#define TIME_ARRAY_OUTPUT_MODE			(2)    	// οģʽ
#define SHIO_OUTPUT_MODE				(3)     // λñȽϿģʽ

//üƵģʽģʽ趨,ԼӦָĹܺͲ
//mode: ģʽ,ο궨
MTN_API short  __stdcall NMC_LaserSetMode  (HAND devHandle, short mode, short ch );

 // ź
#define LASER_NONE 			(0)			// رռģʽ
#define LASER_DA  			(1)			// DA
#define LASER_PWM_DUTY		(2)			// ռձ
#define LASER_PWM_FRQ		(3)			// Ƶ
#define LASER_PWM_FRQ_EXT	(4)			// Ƶ,̶

// ź
// outputType
// index :ͨ,ȡֵΧ[0,n]
// optionVal: Ϊռձʱ,ֵΪPWMƵ,λHZ
//            ΪLASER_PWM_FRQʱ,ֵΪռձֵ,0~100
//            ΪLASER_PWM_FRQ_EXTʱ,ֵΪ,λΪ0.5΢,ȡֵΧ(0,~)
// ch :ͨ,ȡֵΧ[0,n]
MTN_API short  __stdcall NMC_LaserSetOutputType ( HAND devHandle,short outputType,short index,Int32 optionVal,short ch);

// ź(߾)
// outputType
// index :ͨ,ȡֵΧ[0,n]
// optionVal: Ϊռձʱ,ֵΪPWMƵ,λHZ
//            ΪLASER_PWM_FRQʱ,ֵΪռձֵ,λΪٷֱȣ
//            ΪLASER_PWM_FRQ_EXTʱ,ֵΪ,λΪ΢,ȡֵΧ(0,~)
// ch :ͨ,ȡֵΧ[0,n]
MTN_API short  __stdcall NMC_LaserSetOutputTypeEx ( HAND devHandle,short outputType,short index,double optionVal,short ch);

// ܣ,
// outVal: 趨ֵNMC_LaserSetOutputTypeõͶӦ
// chͨ (ҪݲͬźŶ˿趨)
MTN_API short  __stdcall NMC_LaserSetPower ( HAND devHandle,Int32 outVal,short ch);

// ܣȡǰ 
// pVal: ֵ
// chͨ
MTN_API short  __stdcall NMC_LaserGetPower ( HAND devHandle,double *pVal,short ch);

// ܣȡǰ⿪״̬ 
// pOnOffState: ⿪״̬1⴦ڴ״̬0:⴦ڹر״̬
// chͨ
MTN_API short  __stdcall NMC_LaserGetOnOff ( HAND devHandle,short *pOnOffState,short ch);

// ܣ(߾)
// chnͨ (ҪݲͬźŶ˿趨)
// outVal: 趨ֵNMC_LaserSetOutputTypeExõͶӦ
MTN_API short  __stdcall NMC_LaserSetPowerEx ( HAND devHandle,double outVal,short ch);

// ܣ 
// onOffl: 01ʾ򿪻رռ
// chͨ (ҪݲͬźŶ˿趨)
MTN_API short  __stdcall NMC_LaserOnOff ( HAND devHandle,short onOff,short ch);

// ü
// onDelay:ʱ,λus,ȡֵΧ[0,65535]
// offDelay:عʱ,λus,ȡֵΧ[0,65535]
// minValue:Сֵ,ȡֵΧ[0,32767]
// maxValue:ֵ,ȡֵΧ[0,32767]
// standbyPower:,Ϊ0ʾȡ
// ch:ͨ
MTN_API short  __stdcall NMC_LaserSetParam ( HAND devHandle, Int32 onDelay ,
				Int32 offDelay, Int32 minValue ,Int32 maxValue,Int32 standbyPower,short ch);

// ü
// onDelay:ʱ,λus,ȡֵΧ[0,65535]
// offDelay:عʱ,λus,ȡֵΧ[0,65535]
// minValue:СֵDAʱΧ[0,32767],ռձʱΧ[0,100],ƵʱΧ[0,2000000]
// maxValue:ֵDAʱΧ[0,32767],ռձʱΧ[0,100],ƵʱΧ[0,2000000]
// standbyPower:,Ϊ0ʾȡ
// ch:ͨ
MTN_API short  __stdcall NMC_CrdBufLaserSetParam ( HAND crdHandle, Int32 segment,Int32 onDelay ,
				Int32 offDelay, Int32 minValue ,Int32 maxValue,Int32 standbyPower,short ch);

// ȡ
MTN_API short  __stdcall NMC_LaserGetParam ( HAND devHandle, Int32 *pOnDelay,
			Int32 *pOffDelay, Int32 *pMinValue ,Int32 *pMaxValue,Int32 *pStandbyPower,short ch);

// û
// segNo:κ
// overRide:汶,Ϊ0ʾȡ
// followType:,0滮ٶ,1ʵٶ
// ch:ͨ,ȡֵΧ[0,n]
MTN_API short __stdcall NMC_CrdBufLaserSetFollow(HAND crdHandle,Int32 segNo,double overRide,short followType,short ch);

// û
// powerFilter:˲ϵȡֵΧ[0,32]0Ĭϣ
// followAdvMode:㷽
// ch:ͨ,ȡֵΧ[0,n]
MTN_API short __stdcall NMC_LaserSetFollowParam(HAND devHandle,short powerFilter,short followAdvMode,short ch);

// ⿪
// segNo:κ
// onOff:,0ع,1
// ch:ͨ
MTN_API short  __stdcall NMC_CrdBufLaserOnOff ( HAND crdHandle,Int32 segNo,short onOff,short ch);

// ü,ģʽ,ָЧ
// segNo:κ
// power:
// ch:ͨ
MTN_API short  __stdcall NMC_CrdBufLaserPower ( HAND crdHandle,Int32 segNo,Int32 power,short ch);

// ݱ򳤶ֵ
#define LASER_CMP_DATA_LEN_MAX				(10)

// ü
// tableNo  ֧20ű
// pXCmpPosXıȽλ,ΪxCount  
// pYCmpPos: YıȽλ,ΪyCount  
// xCount Xĳ,ȡֵΧ[2,10]
// yCount Yĳ,ȡֵΧ[2,10]
// powerMin:	ڸСŲ
// powerMax:	СڸŲ
// pLaserCmpPowerֵòΪ2ά׵ַ
// chn:Ӧļͨ
MTN_API short  __stdcall NMC_SetLaserPowerCmpTable ( HAND devHandle,short tableNo,Int32 *pXCmpPos,Int32 *pYCmpPos,
	short xCount,short yCount, UInt32  powerMin,UInt32  powerMax,UInt32  *pLaserCmpPower,short chn);

// 
// pAxisNo pAxisNo[0]XλñȽ pAxisNo[1]YλñȽ
// chn·ͨ
MTN_API short  __stdcall NMC_StartLaserPowerComp ( HAND devHandle,short *pAxisNo,short chn);

// ֹͣ
MTN_API short  __stdcall NMC_StopLaserPowerComp ( HAND devHandle,short chn);

// 
#define LASER_GROUP		(12)			// 󼤹
#define LASET_POINT		(40)			// ÿ

typedef struct
{
	short pwmEnable;		// ǷҪPWM,0:һΣ1λ
	short outputType;		// źͣ0gate,1GPO
	short outputCh;			// źͨ
	short stLevelRevs;	    // SHIOƽȡ,ĬΪ0ȡ
	Int32 pwmPeriod;			// ,PWM,λus,Сʱ
	Int32 pwmWidth;			// ,PWM,λus,˲,ʱ
    Int32 gateDistance; 	    // ̶ģʽµλü λpulse
						    // Ĭ0,ģʽ2~4 »ЧԼ
    Int32 minFrqFrq; 	    // ,SHIOƵʣλHZ
    short posSrc; 		    // Ƚģʽ,ⲿڲ滮ֵ
					        // 0ⲿƼ,1ڲ滮ֵ
					        // Ĭ0
    short axisMask; 	    // ,bit λӦһᣩ
						    // Ĭ 0
    short minFrqEn;		    // ,ǷSHIOƵʣĬ0
	short reserved2;	    // 
}TTimeArrayPara;

// ʱ
// ch : ͨ
// pPara  
// ע1.ʱʽЧ
MTN_API short  __stdcall NMC_LaserSetTimeArrayPara  ( HAND devHandle,TTimeArrayPara *pPara,short ch);

typedef struct
{
	unsigned short time[LASET_POINT];// ÿ֮ļʱ,λ΢
	short power[LASET_POINT];		// С
	short count;					// ʵѹ
}TLaserPower;

// ü,ģʽ,groupЧ,pLaserPowerΪָĵϢ
// group : һ鼤
// pLaserPower  õ
// ע1. 
//     2.ýӿڶSHIOģʽЧ
MTN_API short  __stdcall NMC_LaserSetTimeArrayPower  ( HAND devHandle,short group,TLaserPower *pLaserPower );
	
// ִʱм,ֻʱģʽЧ
// group : һ鼤
// ch:ͨ
// ע1.ʱ,ֱһ,һΪ0,άһ
//    2.һΪ0,ûPWM,Զرռ⡣PWMҪNMC_LaserOnOffNMC_CrdBufLaserOnOffرռ
MTN_API short  __stdcall NMC_LaserTimeArrayExe  (HAND devHandle, short group,short ch );

// ִʱм,ֻʱģʽЧ
// segNo:κ
// group:һ鼤
// ch:ͨ
// ע1.ʱ,ֱһ,һΪ0,άһ
//    2.һΪ0,ûPWM,Զرռ⡣PWMҪNMC_LaserOnOffNMC_CrdBufLaserOnOffرռ
MTN_API short  __stdcall NMC_CrdBufLaserTimeArrayExe ( HAND crdHandle,Int32 segNo,short group,short ch);

typedef struct
{
	short isArray; 		// Ƿ̶໹顣0̶֧֣ࣨ,Ĭ0
	short outMode; 		// ģʽĬ1
						// 1ֻgate ,
						// 2: λgate
						// 3: λgate,gate ͬtrigger źͬ
						// 4: λgate,gate źͬ
	short posSrc; 		// Ƚģʽ,ⲿڲ滮ֵ
						// 0ⲿƼ,1ڲ滮ֵ
						// Ĭ0
	short axisMask; 	// ,bit λӦһᣩ
						// Ĭ 0
	double delay; 		// ʱعʱ( ݲ ),λsĬ 0
	double gateTime; 	// gate ʱ,λsڲСֵ1/36us ,ȡֵΧ(0,0.0009)
						// Ĭ0
	Int32 gateDistance; 	// ̶ģʽµλü λpulse
						// Ĭ0,ģʽ2~4 »ЧԼ顣
    Int32 reserved1;		// ,ӦΪ0
	Int32 reserved2; 	// ,ӦΪ0
	Int32 reserved3; 	// ,ӦΪ0
	Int32 reserved4; 	// ,ӦΪ0
	Int32 reserved5; 	// ,ӦΪ0
}TSHIOPara;

// SHIOܵĲ
MTN_API short  __stdcall NMC_SHIOConfigPara  (HAND devHandle, TSHIOPara *pSHIOPara,short ch);

// SHIOСƵʹܿ
// minFrq:ƵʣλHZ
MTN_API short  __stdcall NMC_SHIOEnableMinFrq  (HAND devHandle,Int32 minFrq,short ch);

// SHIOСƵʹܹر
MTN_API short  __stdcall NMC_SHIODisableMinFrq  (HAND devHandle,short ch);

// SHIOСƵʹܿ
// minFrq:ƵʣλHZ
MTN_API short  __stdcall NMC_CrdBufSHIOSetMinFrq(HAND crdHandle, Int32 segment, Int32 minFrq,short ch);

// SHIOСƵʹܹر
MTN_API short  __stdcall NMC_CrdBufSHIOClrMinFrq (HAND crdHandle, Int32 segment,short ch);

// SHIOܵĲ
// delay:ʱعʱ( ݲ ),λsĬ 0
// gateTime:gate ʱ,λsڲСֵ1/36us ,ȡֵΧ(0,0.0009),Ĭ0
// gateDistance:̶ģʽµλü λpulse
MTN_API short  __stdcall NMC_CrdBufSHIOSetParam  (HAND crdHandle, Int32 segment,double delay,
	double gateTime,double gateDistance,short ch);

// лᣨϵȫһ£
MTN_API short  __stdcall NMC_SHIOChangeAxisMask( HAND devHandle, short axisMask,short ch );

// лᣨϵȫһ£,ָ
MTN_API short  __stdcall NMC_CrdBufSHIOChangeAxisMask( HAND crdHandle, Int32 segment, short axisMask,short ch );

// GATE
// עúģʽ
MTN_API short  __stdcall NMC_SHIOGateOn ( HAND devHandle ,short ch);

// ֹGATE
// עúֹ
MTN_API short  __stdcall NMC_SHIOGateOff ( HAND devHandle ,short ch);

// Trigger ,
// triggerFreq : triger ƵʵλHZ
// triggerWidth : triger ,λsڲСֵ1/36us Ĭ0
// עú
MTN_API short __stdcall NMC_SHIOTriggerOn ( HAND devHandle,double freq,double width ,short ch);

// ֹGATE
// עú
MTN_API short  __stdcall NMC_SHIOTriggerOff ( HAND devHandle ,short ch);

// GATE
// עúģʽ
MTN_API short  __stdcall NMC_BufSHIOGateOn ( HAND crdHandle, Int32 segNo,short ch);

//ֹGATE
//עִеָֹ
MTN_API short  __stdcall NMC_BufSHIOGateOff ( HAND crdHandle, Int32 segNo,short ch);

// PWMӳ䵽GATE
// pwmCh:pwm ͨ
// gateCh:gateźͨ
// onOff: 0 -- ӳ䣬1 -- ӳ ĬΪ0
MTN_API short  __stdcall NMC_SetPwmToGate (HAND devHandle, short pwmCh,short gateCh,short onOff);

// SHIO㶯⣬һgate,ע⣺ڼSHIOģʽʹ
// gateTime:gateλ΢
// gateFrq:gateƵʣλHZ
// outCount:
// ch:ͨ
MTN_API short  __stdcall NMC_CrdBufSHIOGatePulse ( HAND crdHandle,Int32 segNo,double gateTime, 
	double gateFrq,Int32 outCount,short ch);

// SHIO㶯⣬һgate,ע⣺ڼSHIOģʽʹ
// gateTime:gateλ΢
// gateFrq:gateƵʣλHZ
// outCount:
// ch:ͨ
MTN_API short  __stdcall NMC_SHIOGatePulse ( HAND devHandle,double gateTime, double gateFrq,Int32 outCount,short ch);

// һPWM,ע⣺ڼSHIOģʽʹ
// onTime:PWMλ΢
// pwmFrq:PWMƵʣλHZ
// outCount:
// ch:ͨ
MTN_API short  __stdcall NMC_PwmPulseOut ( HAND devHandle,double onTime, double pwmFrq,Int32 outCount,short ch);

//------------------------------------------------------------------------------------------------------------
//
//	9.
//
//------------------------------------------------------------------------------------------------------------
// 
// axisHandle: 
// group     : ,ȡֵΧ[0,n]
MTN_API short __stdcall NMC_SetGantryMaster( HAND axisHandle, short group );

// ŴӶ
// axisHandle  : ŴӶ;
// group       : ,ȡֵΧ[0,n]
// gantryErrLmt: ű,ȡֵΧ(0,...)
MTN_API short __stdcall NMC_SetGantrySlave( HAND axisHandle , short group, Int32 gantryErrLmt );

// Źܹر
// group :       ,ȡֵΧ[0,n]
MTN_API short __stdcall NMC_DelGantryGroup( HAND axisHandle, short group );

//------------------------------------------------------------------------------------------------------------
//
//	10.ͨѶչ
//
//------------------------------------------------------------------------------------------------------------
// ͨѶչ
// ûָ,ֻд
MTN_API short  __stdcall NMC_UserCmdWrite( HAND devHandle, unsigned char *sendBuffer, UInt32  sendLen );

// ûָ,ֻ
MTN_API short  __stdcall NMC_UserCmdRead( HAND devHandle, unsigned char *sendBuffer, 
	UInt32  sendLen, unsigned char *recBuffer, UInt32  waitLen );

// ݴ,ֻд
MTN_API short  __stdcall NMC_DataTransfer( HAND devHandle, unsigned char *sendBuffer, UInt32  sendLen );		

// ֹû
MTN_API short __stdcall NMC_SysSetUserApp   ( HAND devHandle, unsigned char mode );

// 
MTN_API short __stdcall NMC_SysUpgrade   ( HAND devHandle );

// ̼
MTN_API short __stdcall NMC_SysUpgradeEx( HAND devHandle, unsigned char cmd, 
	unsigned char *sendBuffer, UInt32  sendLen, unsigned char *recBuffer, UInt32  recvedLen );

// õϢ
MTN_API short __stdcall NMC_SetDebugErrorEn(  HAND devHandle, short debugErrEn );

// ȡһεĴ
// ֵ
MTN_API short __stdcall NMC_GetLastErr(void);

// ָ󷵻ֵģʽ
// mode:0-׼ģʽ,ϸĴ(Ĭ)1--ģʽ,ֻش
MTN_API short __stdcall NMC_SetErrCodeMode(short mode);

// ָͨѶŹ
// timeout:Źʱʱ,λ,Сڵ0رտŹ
// stopMode:ʱֹͣģʽ,1:ֹͣ,0:ִϺֹͣ
// groupID:ʱdo
// doValue:ʱdo״̬
MTN_API short __stdcall NMC_SetWatchDog(HAND devHandle,Int32 timeout,short stopMode,short groupID,Int32 doValue);

//------------------------------------------------------------------------------------------------------------
//
//	11.
//
//------------------------------------------------------------------------------------------------------------
// ˳
MTN_API short __stdcall NMC_ClrHandWheel(HAND devHandle);

// 
// axis:,ȡֵΧ[0,n]
// ratio:汶,ȡֵΧ(0,..],ֵԽ,ͬ,˶Խ
// acc:ļٶ
// vel:ٶ
// עźԴΪ˿
MTN_API short __stdcall NMC_SetHandWheel(HAND devHandle,short axis,double ratio,double acc,double vel);


// ѡָıͨ
// index:ͨ,ͨ,ȡֵΧ[0,n]
//                    չͨ,256ʾһչͨ,257ʾڶ,Դ
MTN_API short __stdcall NMC_SetHandWheelInput(HAND devHandle,short index);

// ָı
// ratio:汶,ȡֵΧ(0,..]
MTN_API short __stdcall NMC_SetHandWheelRatio(HAND devHandle,double ratio);


//------------------------------------------------------------------------------------------------------------
//
//	12.PT
//
//------------------------------------------------------------------------------------------------------------
// onOff:		1פģʽ   0ˢģʽ(Ĭģʽ)
// loopCount:	ѭ פģʽЧ
MTN_API short  __stdcall NMC_MtPtSetStatic(HAND axisHandle,short onOff,Int32 loopCount);

// onOff:		1פģʽ   0ˢģʽ(Ĭģʽ)
// loopCount:	ѭ פģʽЧ
MTN_API short  __stdcall NMC_MtPtGetStatic(HAND axisHandle,short *pOnOff,Int32 *pLoopCount);

// ѯPTʣռС
// pSpace:صʣռС
// pUsed: ʹõĿռ
MTN_API short  __stdcall NMC_MtPtGetSpace(HAND axisHandle,short *pSpace,short *pUsed);


// PTݶ
#define MT_PT_NORMAL	(0)
#define MT_PT_STOP		(1)
#define MT_PT_EVEN		(2)

// Pt˶ѹ˶ݶ
// count:ѹݶ
// pPosArray:о
// pTimeArray:ʱ
// pTypeArray:,궨
MTN_API short  __stdcall NMC_MtPtPush(HAND axisHandle,short count,double *pPosArray,Int32 *pTimeArray,short *pTypeArray);

// PT
MTN_API short  __stdcall NMC_MtPtBufClr(HAND axisHandle);

// Pt˶
// otherSynAxCnts axisHandle ͬ
// pOtherSynAxArray: ͬţ0~N	
// עͬͬһ
MTN_API short  __stdcall NMC_MtPtStartMtn(HAND axisHandle,short otherSynAxCnts,short *pOtherSynAxArray);


//-------------------------------------------------------------------------------
// 13.ԾλñȽ
//-------------------------------------------------------------------------------

// ȷṹ
typedef struct
{
	short dimens;
	short compMode;
	short axMask;
	short src;
	double gateTime;
}TLinearCmpPara;


// ܣþȷλñȽϵĲλñȽλ
// dimens:Ƚϵά 12
// axisMaskѡȽϵ,bitѡ:ܳ2bitͬʱΪ1
// srcȽԴ1:λ  0滮λ
// cmpModeȽϵģʽ0 λñȽ,1 ԱȽ,intervalȽ
// gateTime:
// chnͨ Ŀǰֻ֧0
MTN_API short __stdcall NMC_LinearCompSetParam(HAND devHandle,short dimens, short axisMask,short src,short cmpMode,double gateTime,short chn);


// ȡò
MTN_API short __stdcall NMC_LinearCompGetParam(HAND devHandle,TLinearCmpPara *pLinearCmpPara,short chn);


// ܣþȷȽλ
// pStartPosʼȽλãע⣺ʱû
// pPos :Ƚϵλַ
//		 ע⣺ΪԾ룬һΪNMC_LinearCompOnOffʱλõľ룬ڶΪԵһľ
// countȽϵλøܳ250Ƚݹ࣬ͨεõķʽѹݣ
// chnͨ Ŀǰֻ֧0
MTN_API short __stdcall NMC_LinearCompSetData(HAND devHandle,Int32 *pStartPos,Int32 *pPos,Int32 count, short chn);


// ܣԱȽ
// pStartPosʼȽλ
// interval:ԱȽϼࣨС32767
// count: ԱȽϴ
MTN_API short __stdcall NMC_LinearCompInterval(HAND devHandle,Int32 *pStartPos,Int32 interval,Int32 count, short chn);


// ܣȷλñȽʹ
// onOff 0 ֹͣ,1
// chnͨ Ŀǰֻ֧0
MTN_API short __stdcall NMC_LinearCompOnOff(HAND devHandle,short onOff, short chn);


// ܣȽϵ״̬
// pStatus: 0 δȽ 1 Ƚ
// pOutCountĸ,ģʽѯ
// chnͨ Ŀǰֻ֧0
MTN_API short __stdcall NMC_LinearCompStatus(HAND devHandle,short *pStatus, short *pOutCount,short chn);

//-------------------------------------------------------------------------------
//14.άλõȽ
//-------------------------------------------------------------------------------
#define CMP_OUTPUT_CHN_MAX	(3)

// άλõȽϽṹ
typedef struct
{
	short outputchn[CMP_OUTPUT_CHN_MAX];		// Ƚͨ:-1ʾ
	short outputType[CMP_OUTPUT_CHN_MAX]; 		// ʽ01ƽ
	short chnType[CMP_OUTPUT_CHN_MAX];      	// ͨͣ0 GPO, 1  GATEͨ
	short dir1No; 								// 1 λԴţ0~11
	short dir2No; 								// 2 λԴţ0~11
	short posSrc; 								// λ 0滮1
	short stLevel[CMP_OUTPUT_CHN_MAX];			// ƽģʽµʼƽ01
	short gateTime[CMP_OUTPUT_CHN_MAX]; 		// 巽ʽʱ:λms
	short errZone; 								// Ƚϵݲ뾶Χpulse
} TComp2DimensParam;


// ܣ2άλñȽϵĲ
// param: άȽϲ
// group:,0 1
// chn:,Ϊ0
MTN_API short __stdcall NMC_Comp2DimensSetParam(HAND devHandle,short group,TComp2DimensParam *param,short chn);


// ܣȡ2άλñȽϵĲ
// param: άȽϲ
// group:,0 1
// chn:,Ϊ0
MTN_API short __stdcall NMC_Comp2DimensGetParam(HAND devHandle,short group,TComp2DimensParam *param,short chn);


// ܣöάȽ
// pArrayPos:Ƚַ
// count:λõ
// group:,0 1
// chn:,Ϊ0
MTN_API short __stdcall NMC_Comp2DimensSetData(HAND devHandle,short group,Int32 *pArrayPos,short count,short chn);


// ܣ2άλñȽʹ
// onOff 0 ֹͣ,1
// group:,0 1
// chn:,Ϊ0
MTN_API short __stdcall NMC_Comp2DimensOnoff(HAND devHandle,short group,short onOff,short chn);


// ܣ2άλñȽϵ״̬
// pStatus: 0 δȽ 1 Ƚ
// pOutCountĸ
// group:,0 1
// chn:,Ϊ0
MTN_API short __stdcall NMC_Comp2DimensStatus(HAND devHandle,short group,short *pStatus, short *pOutCount,short chn);
//-------------------------------------------------------------------------------
//15.άλñȽͨýӿ
//-------------------------------------------------------------------------------
// XάλõȽϽṹ
typedef struct
{
	short dimens; 		                    // ά
	short axMask;                           // ʹõ,λ
	short src; 		                        // λ 0滮1

	short outCnts; 							// 
	short outType[CMP_OUTPUT_CHN_MAX]; 		// ʽ01ƽ
	short outChnType[CMP_OUTPUT_CHN_MAX];	// ͨͣ0 GPO, 1  GATEͨ
	short outIndex[CMP_OUTPUT_CHN_MAX];     // GPO0~63  GATE0
	short outStLevel[CMP_OUTPUT_CHN_MAX];   // ƽģʽµʼƽ01
	short outGateTime[CMP_OUTPUT_CHN_MAX]; 	// ģʽµʱ:λms
	short errZone; 							// Ƚϵݲ뾶Χpulse
} TCompXDimensParam;

// ܣXάλñȽϵĲ
// param: XάȽϲ
// ch:,0~2
MTN_API short __stdcall NMC_CompXDimensSetParam(HAND devHandle,TCompXDimensParam *param,short chn);

// ܣȡXάλñȽϵĲ
// param: άȽϲ
// chn:
MTN_API short __stdcall NMC_CompXDimensGetParam(HAND devHandle,TCompXDimensParam *param,short chn);

// ܣXάλñȽϵģʽ
// outMode: ģʽ 0ͬʱģʽ 1 ѭģʽ
// ch:,0~N
MTN_API short __stdcall NMC_CompXDimensSetCmpOutMode(HAND devHandle,short outMode ,short chn);

// ܣXάȽ
// pArrayPos:Ƚַ,ע1άȽ,pPosArrayһάַ,2άȽ,pPosArrayӦ2άַ
// outValue
// count:λõ,עΪ2άȽʱ,ÿΪһ
// ch:,0~N
// עṹ嶨IO,ͬʱ
MTN_API short __stdcall NMC_CompXDimensSetData(HAND devHandle, Int32 *pPosArray, short count, short chn);

// ܣXάλñȽʹ
// onOff 0 ֹͣ,1
// chn 
MTN_API short __stdcall NMC_CompXDimensOnoff(HAND devHandle,short onOff, short chn);

// ܣXάλñȽϵ״̬
// pStatus: 0 δȽ 1 Ƚ
// pOutCountĸ
// chn
MTN_API short __stdcall NMC_CompXDimensStatus(HAND devHandle,short *pStatus, short *pOutCount,short chn);

//-------------------------------------------------------------------------------
//16.ϵתݻеṹת
//-------------------------------------------------------------------------------
// ܣʹתת
//       ûǰֱ,ʵʼӹһתϼӹ,ô˹
// rotAxisNoת
// angleRadEqualתתϵ
// firstAxisInitPosת,Xλ
// secAxisInitPosת,Yλ
MTN_API short  __stdcall NMC_CrdSetTransRotate(HAND crdHandle,short rotAxisNo,
								double angleRadEqual,Int32 firstAxisInitPos,Int32 secAxisInitPos);

// ܣرתת
MTN_API short  __stdcall NMC_CrdDelTransRotate(HAND crdHandle);

// ܣʹܼת
//       ûǰֱ,ʵʻеһתһ
//	rotAxNoת
//		transAxNoƽ
//		rotEquivתᵱ,2PI/һȦ
MTN_API short  __stdcall NMC_CrdSetTransPolar(HAND crdHandle, short rotAxNo,short transAxNo, double rotEquiv);

// ܣ趨ļλòҽȦ㴦õPTPеָλã
//	xPos:ϵXλ
//		yPos:ϵYλ,˶5000,5000λ,൱תת45Ƚ,˶2*5000λ
//		rotVel:תٶ
//		transVel:ٶ
MTN_API short  __stdcall NMC_CrdRunToPolarPos(HAND crdHandle,double xPos,double yPos,double rotVel,double transVel);

// ܣ趨ļǶλãõPTPеָλã
//	theta:תĿǶ
//				vel:תٶ
//				clrRoundFlag:ǷȦ
MTN_API short  __stdcall NMC_CrdRunToPolarTheta(HAND crdHandle,double theta,double vel,short clrRoundFlag);

// ܣټֱָֻͣϵ
MTN_API short  __stdcall NMC_CrdDelTransPolar(HAND crdHandle);

//-------------------------------------------------------------------------------
//17.ṹʼ
//-------------------------------------------------------------------------------
MTN_API short  __stdcall NMC_TSafeParaStructInit(HAND devHandle,TSafePara *pPara);
MTN_API short  __stdcall NMC_TCrdConfigStructInit(HAND devHandle,TCrdConfig *pPara);
MTN_API short  __stdcall NMC_TCrdSafeParaStructInit(HAND devHandle,TCrdSafePara *pPara);
MTN_API short  __stdcall NMC_THomeSettingStructInit(HAND devHandle,THomeSetting *pPara);
MTN_API short  __stdcall NMC_TArcSecSettingStructInit(HAND devHandle,TArcSecSetting *pPara);
MTN_API short  __stdcall NMC_TCrdParaStructInit(HAND devHandle,TCrdPara *pPara);
MTN_API short  __stdcall NMC_TCollectCfgStructInit(HAND devHandle,TCollectCfg *pPara);
MTN_API short  __stdcall NMC_TCollectTrigStructInit(HAND devHandle,TCollectTrig *pPara);
MTN_API short  __stdcall NMC_TTimeArrayParaStructInit(HAND devHandle,TTimeArrayPara *pPara);
MTN_API short  __stdcall NMC_TLaserPowerStructInit(HAND devHandle,TLaserPower *pPara);
MTN_API short  __stdcall NMC_TSHIOParaStructInit(HAND devHandle,TSHIOPara *pPara);
MTN_API short  __stdcall NMC_TLinearCmpParaStructInit(HAND devHandle,TLinearCmpPara *pPara);
MTN_API short  __stdcall NMC_TComp2DimensParamStructInit(HAND devHandle,TComp2DimensParam *pPara);
MTN_API short  __stdcall NMC_TPtpParaStructInit(HAND devHandle,TPtpPara *pPara);
MTN_API short  __stdcall NMC_TJogParaStructInit(HAND devHandle,TJogPara *pPara);
MTN_API short  __stdcall NMC_TNMCTimeStructInit(HAND devHandle,TNMCTime *pPara);

// ״̬,ͬʱ
MTN_API short  __stdcall NMC_MtClrErrorEx(HAND axisHandle,short count);

// DO,16λ
// bitsFlag,0:16λ,116λ
MTN_API short  __stdcall NMC_SetDOGroupEx( HAND devHandle, Int32 value, short groupID,short bitsFlag) ;

//-------------------------------------------------------------------------------
//18.ջ
//-------------------------------------------------------------------------------

// PID
typedef struct
{
    float kp;											// ϵ
    float ki;											// ϵ
    float kd;											// ΢ϵ
    float kvff;											// ٶǰϵ
    Int32 integralLimit;                                 // ֱͼ
    Int32 derivativeLimit;                               // ΢ֱͼ
    short outLimit;                                     // ͼ
} TPidPara;

// Dac
typedef struct
{
	short inverse;			// ѹǷȡ
	short bias;				// DacƯ
	short dacLmt;			// Dacֵ
}TDacMotor;

// õջƵDA,DAͨĶӦ
MTN_API short  __stdcall NMC_MtSetCloseLoopDac (HAND axisHandle,TDacMotor *pDacPara);

// ȡջƵDA
MTN_API short  __stdcall NMC_MtGetCloseLoopDac (HAND axisHandle,TDacMotor *pDacPara);

// õĿģʽĬʹöӦıΪ뷴,ӦŵDACΪ
// ջģʽ,ȵNMC_SetCloseLoopDacָ
//mode: 0   1 DAջƣĬΪ
MTN_API short  __stdcall NMC_MtSetCtrlMode(HAND axisHandle,short mode);

// ȡĿģʽ
MTN_API short  __stdcall NMC_MtGetCtrlMode(HAND axisHandle,short *pMode);


//öӦŵPID
MTN_API short  __stdcall NMC_MtSetPIDPara(HAND axisHandle,short index, TPidPara *pidPara);

// ȡӦŵPID
MTN_API short  __stdcall NMC_MtGetPIDPara(HAND axisHandle,short index, TPidPara *pPidPara);

// ʹPID
MTN_API short  __stdcall NMC_MtSetPIDIndex(HAND axisHandle,short index);

// ȡʹõPID
MTN_API short  __stdcall NMC_MtGetPIDIndex(HAND axisHandle,short *pIndex);

//-------------------------------------------------------------------------------
//19.߼BufIoü
//-------------------------------------------------------------------------------
// BufIo
#define MAX_ADV_BUFIO_GROUP	2

// ߼BufIo
typedef struct
{
	// 
	short outType;				// ͣ0ͨ1Gateźţ
	short outGroup;				// 飬ȡֵΧ[0,n]
	short outIndex;				// ţȡֵΧ[0,n]
	short outSns;				// Чƽ,0:͵ƽЧ1ߵƽ
	
	// ź
	short pulseMode;		// 0ƽ1W
	Int32  pulseOnTime;		// Чƽʱ䣨ʽЧλ΢
	Int32  pulseOffTime;		// Чƽʱ䣨ʽЧλ΢
	
	unsigned char reserved[32];	// 
}TAdvBufIoParam;

// BufIo
MTN_API short  __stdcall NMC_AdvBufIoSetParam(HAND devHandle,TAdvBufIoParam *pPrm,short ch);

// ȡBufIo
MTN_API short  __stdcall NMC_AdvBufIoGetParam(HAND devHandle,TAdvBufIoParam *pPrm,short ch);

// ø߼BufIoЧ˶һξض״̬
// outLength:룬λ
// value: ģʽƽʽ塣
// ch:飬ȡֵΧ[0,MAX_ADV_BUFIO_GROUP)
MTN_API short  __stdcall NMC_CrdAdvBufIoOnAfterLen(HAND crdHandle,Int32 segNo,
	Int32 outLength,Int32 value,short ch);

// ø߼BufIoرȫ˶ǰǰһξض״̬
// outLength:룬λ
// ch:飬ȡֵΧ[0,MAX_ADV_BUFIO_GROUP)
MTN_API short  __stdcall NMC_CrdAdvBufIoOffBeforeLen(HAND crdHandle,Int32 segNo,Int32 outLength,short ch );
	
// ø߼BufIo
// value: ģʽƽʽ0:رգ1:򿪡
// ch:飬ȡֵΧ[0,MAX_ADV_BUFIO_GROUP)
MTN_API short  __stdcall NMC_AdvBufIoOut(HAND devHandle,Int32 value,short ch);

// ȡBufIo
// pOutCout:
// ch:飬ȡֵΧ[0,MAX_ADV_BUFIO_GROUP)
MTN_API short  __stdcall NMC_AdvBufIoGetPulseCnt(HAND devHandle,Int32 *pOutCout,short ch);

// DOͨ
#define MAX_NUM_DOBIT_PULSE		4

// DO
// doType:DO,0ͨ
// doIndex:DOţȡֵΧ[0,n]
// highLevelTime:ߵƽȣλ:us
// lowLevelTime:͵ƽȣλ:us
// outCount:
// firstLevel:0͵ƽ1ߵƽ
// ch:ͨ,ȡֵΧ:[0,MAX_NUM_DOBIT_PULSE-1]
MTN_API short  __stdcall NMC_DoBitPulseEnable(HAND devHandle,short doType,short doIndex,
	Int32 highLevelTime,Int32 lowLevelTime,Int32 outCount,short initialLevel,short ch);

// رDO
MTN_API short  __stdcall NMC_DoBitPulseDisable(HAND devHandle,short ch);

// DO 
MTN_API short  __stdcall NMC_CrdBufDoBitPulseEnable(HAND crdHandle, Int32 segNo,short doType,short doIndex,
	Int32 highLevelTime,Int32 lowLevelTime,Int32 outCount,short initialLevel,short ch);

// رDO
MTN_API short  __stdcall NMC_CrdBufDoBitPulseDisable(HAND crdHandle, Int32 segNo,short ch);

//-------------------------------------------------------------------------------
//20.ģ
//-------------------------------------------------------------------------------

// DACģͨģʽ
// ch:ģͨ,ȡֵΧ[0,n]
// mode:ģΧ,0:0~5V, 1:0~10V, 2: 0~10.8V, 3:+/-5V, 4:+/-10V, 5:+/-10.8V,ЧĬΪ4
MTN_API short __stdcall NMC_SetDacMode(HAND devHandle,short ch, short mode);

// ȡDACģͨģʽ
// ch:ģͨ,ȡֵΧ[0,n]
// pMode:صģΧ趨ֵ
MTN_API short __stdcall NMC_GetDacMode(HAND devHandle,short ch,short *pMode);

// Adc
// ch:ģͨ,0~7ʾͨϵAD256ʾչAD
// mode:ģΧ,0:0~5V, 1:0~10V, 2: 0~10.8V, 3:+/-5V, 4:+/-10V, 5:+/-10.8V,ĬΪ4
// ע⣺Ŀǰֻ֧+/-10V
// filterCoe:˲ϵȡֵΧ[0,64],0ʾȡAdc˲λ:msĬֵΪ0
MTN_API short __stdcall NMC_SetAdcMode(HAND devHandle,short ch,short range,short filterCoe);

// ȡAdc
// ch:ģͨ,0~7ʾͨϵAD256ʾչAD
// pMode:ģΧ
// pFilterCoe:˲ϵ
MTN_API short __stdcall NMC_GetAdcMode(HAND devHandle,short ch,short *pRange,short *pFilterCoe);

// DACģֵ
// ch:ģͨ,ȡֵΧ[0,n]
// dacValue:ģֵ,ȡֵΧ[-32768,32767],ӦDACΧ
MTN_API short __stdcall NMC_SetDac(HAND devHandle,short ch,short dacValue);

// ȡDACģֵ
// ch:ģͨ,ȡֵΧ[0,n]
// pDacValue:ģֵ,ȡֵΧ[-32768,32767],ӦDACΧ
MTN_API short __stdcall NMC_GetDac(HAND devHandle,short ch,short *pDacValue);

// ȡADCģ룩ֵ
// ch:ģͨ,ȡֵΧ[0,n]
// pAdcValue:ģֵȡֵΧ[-32768,32767],ӦAdcѹΧ
MTN_API short __stdcall NMC_GetAdc(HAND devHandle,short ch,short *pAdcValue);


//-------------------------------------------------------------------------------
//21.scara
//-------------------------------------------------------------------------------
// ؽṹ
typedef struct
{
    double arm1Len;         // 1λûλ
    double arm2Len;         // 2λûλ
    double pitch;           // Z˿˽ھ࣬λûλ
    double reserved[16];    // Ϊ0
}TScaraMechPara;

typedef struct
{
    Int32 encBits;          // ؽڵĵһȦ
    Int32 zeroPulsePos;     // ؽλõλ
    float posLmt;           // ؽڵλλãλ 
    float negLmt;           // ؽڵĸλλãλ 
    float ratio;            // ٱ
    float maxVel;           // ؽٶ  λ  /s
    float maxAcc;           // ؽڼٶ: λ /s^2
	float reserved1;		// Ϊ0
    double reserved[8];	    // Ϊ0
}TScaraJiontPara;

// ûе
MTN_API short  __stdcall NMC_CrdSetScaraMechPara(HAND crdHandle,TScaraMechPara *pScaraMechPara);

// ȡе
MTN_API short  __stdcall NMC_CrdGetScaraMechPara(HAND crdHandle,TScaraMechPara *pScaraMechPara);

// ùؽڲ
MTN_API short  __stdcall NMC_CrdSetScaraJiontPara(HAND crdHandle,short jointNo,TScaraJiontPara *pScaraJiontPara);

// ȡؽڲ
MTN_API short  __stdcall NMC_CrdGetScaraJiontPara(HAND crdHandle,short jointNo,TScaraJiontPara *pScaraJiontPara);

// crdΪscara
// jointNum: 2/3
// jointAxNoArray 鳤Ϊ4õΪ0
MTN_API short  __stdcall NMC_CrdSetTransScara(HAND crdHandle, short jointNum, short *jointAxNoArray );

// scara
MTN_API short  __stdcall NMC_CrdDelTransScara(HAND crdHandle);

typedef struct
{
   short masterAxNo;	// ţ0~N
   short useEnc;	// ʹñ0滮1
   short dirReverse;    // ᷽ȡ0ȡ1ȡ

   short followedAxNo;   // ĸᣬ0:X1:Y
   double posCoe;	 // ᵱ͸ĵ浱 / ᵱ
  
   Int32  reserved2[16];  // Ϊ0
}TFlyFollowPara;

// crd÷иģʽ
// *pFlyFollowPara ģʽ
MTN_API short  __stdcall NMC_CrdSetFlyFollow(HAND crdHandle, TFlyFollowPara *pFlyFollowPara);

// ٷи
MTN_API short  __stdcall NMC_CrdDelFlyFollow(HAND crdHandle);

//-------------------------------------------------------------------------------
//22.ϵ汣ָ
//-------------------------------------------------------------------------------
#define CRD_INTERF_GROUP_MAX		(2)

// ϵĸ汣
// groupNo: ϵţĿǰֻϵԸֵΪ0
// mode:	0:ģʽָ棬ϵֹͣ  1ģʽָ棬һֹͣ뿪
MTN_API short  __stdcall NMC_SetMvProtect(HAND devHandle,short groupNo,short mode);

// ȡϵĸ汣
// groupNo: ϵţĿǰֻϵԸֵΪ0
MTN_API short  __stdcall NMC_DelMvProtect(HAND devHandle,short groupNo);

// ȡϵĸ״̬
// groupNo: ϵţĿǰֻϵԸֵΪ0
// pSts:	0 û湦 1  ûгָ  2 淢
MTN_API short  __stdcall NMC_GetMvProtectSts(HAND devHandle,short groupNo,short *pSts);

typedef struct
{
   short crdNo[2];		// Ҫ汣ϵ
   short crdAxNo[2];	// ϵĸ,ָXYZһX:0  Y:1    Z:2
   short moveDir[2];    // ֱСʱ˶1 -1

   Int32 orgDis;			// ϵcrdAxNoԭʱľ
   Int32 mvProtectDis;	 // ı   
   Int32 safeWaitPos;	// modeΪģʽʱҪֹͣĵȴλãmodeΪ0ʱЧ
   short stopCrdNo;		// modeΪģʽʱҪֹͣϵţmodeΪ0ʱЧ
   short reserved;      // 
}TMvProtectPara;

// ϵĸ汣
// groupNo:	ϵţĿǰֻϵԸֵΪ0
// pCrdInterfProtectPara 
MTN_API short  __stdcall NMC_SetMvProtectMode01Para(HAND devHandle,short groupNo,TMvProtectPara *pMvProtectPara);

// ȡϵĸ汣
// groupNo:	ϵţĿǰֻϵԸֵΪ0
// pCrdInterfProtectPara 
MTN_API short  __stdcall NMC_GetMvProtectMode01Para(HAND devHandle,short groupNo,TMvProtectPara *pMvProtectPara);


//-------------------------------------------------------------------------------
//23.ָ
//-------------------------------------------------------------------------------
typedef struct
{
    short crdSts;          // ϵ״̬
    short axSts[3];        // ϵ״̬
    Int32  prfPos[3];       // ûϵµĹ滮λ
    Int32  axisPos[3];      // еϵµĹ滮λ
    Int32  encPos[3];        // λ
    Int32  userSeg;         // еĻκ
    double  prfVel;         // ˶ٶ
    Int32  gpDi;             // ͨ0~31
    Int32  gpDo;             // ͨ0~31
    short  motDi[3];        // λԭ㡢οרIOλ(  BIT_AXMTIO_LMTN )
    short  reserved;        // 
    Int32 crdFreeSpace;      // ʣռ
    Int32 reserved2;
}TPackedCrdSts3;
// ϵ˶ģʽ,ȡ״̬
MTN_API short __stdcall NMC_CrdGetStsPack3( HAND crdHandle, TPackedCrdSts3 *pPackSts );

// ϵģʽ,ȡĻеλ
// cnts: ȡ,1~N
// pPos
MTN_API short __stdcall NMC_CrdGetAxisPos(HAND crdHandle,short cnts, Int32 *pPosArray);

// ȡ滮λXYZ
// cnts: ȡ,1~N
// pPosArray
MTN_API short __stdcall NMC_CrdGetPrfPos( HAND crdHandle, short cnts, Int32 *pPosArray );

// ȡλ
// cnts: ȡ,1~N
// pPos顣
MTN_API short __stdcall NMC_CrdGetEncPos  ( HAND crdHandle, short cnts, Int32 *pPosArray );

// ȡϵϳٶ
// pVelϵϳٶ
MTN_API short __stdcall NMC_CrdGetVel(HAND crdHandle,double *pVel);

// ϵ
// pCrdHandleϵ
MTN_API short __stdcall NMC_CrdOpen(HAND devHandle, PHAND pCrdHandle );

// ἱͣ
// ע˶ᰴ趨ļͣٶֹͣû,ֹͣ
MTN_API short __stdcall NMC_MtEstp    ( HAND axisHandle );

// ȡ״̬8ᣩ
typedef struct
{
	Int32 prfPos[8];     // 滮λ
	Int32 encPos[8];     // ʵλ
	float prfVel[8];    // 滮ٶ
	Int32 motionIO[8];   // רIO
	short sts[8];       // ״̬
	Int32 gpo;            // ͨ
	Int32 gpi;            // ͨ
}TAxisStsPack8;
// ȡ8״̬,ӵһῪʼȡ
// axisFirstHandle : һ
// pPackSts: ״̬,οṹ嶨
MTN_API short  __stdcall NMC_MtGetStsPack8  ( HAND axisFirstHandle, TAxisStsPack8 *pPackSts );

// ֱ߲岹
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// mask:,λʾ
// pTgPosArrayĿλ,Ϊ3
MTN_API short __stdcall NMC_CrdLineXYZ(  HAND crdHandle,  Int32 segNo, short mask,Int32 *pTgPosArray, double endVel, double vel,double synAcc );

// ȡͨ(ͨ,ֳ֧32λ)
// groupID:DO,ȡֵΧ[0,n],,0: DO31~DO0, 1: DO63~DO32,ָչIOģ
// pDoValue: ͨ1, ߵƽ,0,͵ƽ
MTN_API short  __stdcall NMC_GetDO( HAND devHandle, short groupID, Int32 *pDoValue);

// ͨ(ͨ,ֳ֧32λ)
// groupID:DO,ȡֵΧ[0,n],ҪǷڶ
// value: ͨ1, ߵƽ,0,͵ƽ
MTN_API short  __stdcall NMC_SetDO( HAND devHandle, short groupID, Int32 value ) ;

// ͨ(ͨ,ֳ֧32λ) 
// groupID:DI,ȡֵΧ[0,n],0: DI31~DI0, 1: DI63~DI32,ָչIOģ
// pInValue: ֵͨ1, ߵƽ,0,͵ƽ
MTN_API short __stdcall NMC_GetDI( HAND devHandle, short groupID, Int32 *pInValue );

// λǷֹͣ˶
// posEnλ,1Ϊ,0Ϊֹ
// negEn: λ
MTN_API short  __stdcall NMC_MtLmtOnOff    ( HAND axisHandle, short posSwt, short negSwt );

// λشƽ
// posSwtλƽ,1Ϊߵƽ,0Ϊ͵ƽ
// negSwt: λƽ
MTN_API short  __stdcall NMC_MtLmtSns      ( HAND axisHandle, short posSwt, short negSwt );

// ԭ㿪شƽע⣺ĵƽòӰ첶ĵƽ
// snsԭƽ,1Ϊߵƽ,0Ϊ͵ƽ
MTN_API short  __stdcall NMC_MtHomeSns( HAND axisHandle, short sns);

// ȡԭ㿪شƽ
// pSnsǰԭƽ,1Ϊߵƽ,0Ϊ͵ƽ
MTN_API short  __stdcall NMC_MtGetHomeSns( HAND axisHandle, short *pSns);

// ŷǷֹͣ˶
// swtŷ,1Ϊ,0ΪֹĬΪߵƽ
MTN_API short  __stdcall NMC_MtAlarmOnOff  ( HAND axisHandle, short swt );

// ŷصƽ
// swtŷƽ,1Ϊߵƽ,0Ϊ͵ƽ
MTN_API short  __stdcall NMC_MtAlarmSns    ( HAND axisHandle, short swt );

// ȡ״̬12ᣩ
typedef struct
{
	Int32 prfPos[12];     // 滮λ
	Int32 encPos[12];     // ʵλ
	float prfVel[12];    // 滮ٶ
	Int32 motionIO[12];   // רIO
	short sts[12];       // ״̬
	Int32 gpo;            // ͨ
	Int32 gpi;            // ͨ
}TAxisStsPack12;
// ȡ12״̬,ӵһῪʼȡ
// axisFirstHandle : һ
// pPackSts: ״̬,οṹ嶨
MTN_API short  __stdcall NMC_MtGetStsPack12  ( HAND axisFirstHandle, TAxisStsPack12 *pPackSts );

//------------------------------------------------------------------------
//                                                     
//  24.Զ״̬
//                                                   
//------------------------------------------------------------------------
// ״̬ṹ
typedef struct
{
    short          mtSts[12];          // ״̬
    short          mtMio[12];          // רIO
	Int32           mtPrfPos[12];       // 滮λ
    Int32           mtEncPos[12];       // ʵλ
	float          mtPrfVel[12];       // 滮ٶ

    short          crdSts[2];          // ϵ״̬
	float          crdPrfVel[2];	   // ϵ˶ٶ
	Int32           crdUserSeg[2];      // ϵеĻκ
	Int32           crdFreeSpace[2];    // ϵʣռ
    Int32           crdUsedSpace[2];    // ϵʹÿռ

    Int32           gpi;                // ͨ
    Int32           gpo;                // ͨ
    short          reserved[32];       // Ԥ

}TAutoRtnPackedSts;

// Զ״̬
// mode1 : Щ״̬أ0̶ʱڷأĬϣ; 1+״̬仯ϵ״̬仯
// mode2 : 
// cycleInMs: ڣλmsȡֵ5~10000ֵ100ms
// port: ˿ڣд0޸ģ
// hostTag : λǩд0޸ģ
MTN_API short __stdcall NMC_DevAutoRtnSet( HAND devHandle, Int32 mode1, Int32 mode2, Int32 cycleInMs, Int32 port, Int32 hostTag );

// ýԶ״̬
MTN_API short __stdcall NMC_DevAutoRtnClr( HAND devHandle );

// ͬ
// ֮ǰ״̬Ժָͬͺ״̬
// hostTag : λǩд0
MTN_API short __stdcall NMC_DevAutoRtnSyn( HAND devHandle, Int32 hostTag );

// ״̬
// packedSts : ״̬
MTN_API short __stdcall NMC_DevAutoRtnGet( HAND devHandle, TAutoRtnPackedSts * packedSts, short *pReady );

// PTPλñȽ
// comparaPos Ŀλãλ 
// upDateVelȽϺĸٶ pulse/ms
MTN_API short __stdcall NMC_MtSetPtpComparePara( HAND axisHandle,short dir, Int32 comparaPos, double upDateVel);

// ȡPTPȽ״̬
MTN_API short __stdcall NMC_MtGetPtpCompareSts( HAND axisHandle,short *pIsCompareActive,short *pIsCompareOut);


//------------------------------------------------------------------------
//                                                     
//  Group 26 : һάλñȽ
//                                                   
//------------------------------------------------------------------------

#define CMP_HS1DIMENS_CHN_MAX	(4)         // ֧ĸͨ
#define CMP_HS1DIMENS_POS_MAX	(8)         // ÿ֧ͨ8λõ

// һάλñȽϲṹ
typedef struct
{
short dirNo;            // Դ0~7Ӧ0~7ı
short out1StLevel;      // out1ʼƽ01
short out2StLevel;      // out2ʼƽ01
short reserved;         // 
Int32 out1Width;         // out1ȣ0~65535,λus
Int32 out2Width;         // out2ȣ0~65535,λus
Int32 out2Delay;         // out2ʱ0~65535,λus
} TCompHs1DimensParam;

// ܣø1άλñȽϵĲȽϱ
// param: һάȽϲ
// chnͨ,Χ0~3
// ע1)Ҫñģʽⲿڲ
//???? 2)ȽλοӲֲᡣ
//???? 3)out1Ƚλõ, out2λʱ
MTN_API short __stdcall  NMC_CompHs1DimensSetParam(HAND devHandle, TCompHs1DimensParam *param,short chn );

// ܣȡ1άλñȽϵĲ
// param, chnͬ
MTN_API short __stdcall NMC_CompHs1DimensGetParam(HAND devHandle, TCompHs1DimensParam *param,short chn);

// ܣø1άȽ
// pArrayPos:Ƚַ
// count:λõ
// chn: ͬ
MTN_API short __stdcall NMC_CompHs1DimensSetData(HAND devHandle,Int32 *pArrayPos,short count,short chn);

// ܣ1άλñȽʹ
// onOff 0 ֹͣ,1
// chn: ͬ
MTN_API short __stdcall NMC_CompHs1DimensOnOff(HAND devHandle, short onOff,short chn);

// ܣ1άλñȽϵ״̬
// pBusy: 0 δȽ 1 Ƚ
// pOutCountĸ
// pWaitCntsȴȽϵĸ
// pFreeCntsеĸ
// chn: ͬ
MTN_API short __stdcall NMC_CompHs1DimensStatus(HAND devHandle, short * pBusy, short *pOutCount, short *pWaitCnts, short *pFreeCnts, short chn);


typedef struct
{
    double smoothDec;		// ֹͣٶ
    double abruptDec;		// ͣٶȣʱ
    double reserved1[2];	// 
    long dataMode;			// ģʽ1פģʽ   0ˢģʽ(Ĭģʽ)
    long loopCount;			// ѭ פģʽЧ
    long reserved2[4];      // 
}TPvtPara;



#ifdef __cplusplus
}
#endif

#endif	// _H_MTN_LIB20_EXT_H_
