////**********************************************************************************************************
//
//  Copyright(c) 2017, Shenzhen Gaochuan Industrial Automation Co.,Ltd
//
//  Moudle Name :   nmc_lib20.h
//
//  Abstract    :   GaoChuan Motion 2.0 User Header
//
//  Note        :   1.ṹ嶨е'reservedxxx'ĳԱǱ,Ϊ,Ϊ0
//                  2.ر˵,APIRTN_CMD_SUCCESS0ֵʾִгɹ,ʾ,mtn_lib20_err.h
//                  3.еAPI,ر˵,axisHandleʾľ,devHandleʾĿľ,
//                    crdHandleʾĿϵ
//                  4.ر˵,APIĲ,ǣ浽0ʼ,NMC_MtOpenеitemNo,0ʾһᡣ
//                  5.mtn_lib20еĽṹ嶼ֽڶ뷽ʽ룬Ϊ˱ṹ⣬뽫뻷Ϊֽڶ
// Modification History :
//
////**********************************************************************************************************
#ifndef _H_NMC_LIB20_H_
#define _H_NMC_LIB20_H_

#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------------------------------------
//
//              궨
//
//------------------------------------------------------------------------------------------------------------
// 
#ifndef MTN_API
    #ifdef WIN32 
        #ifdef NMC_LIB_EXPORTS
            #define MTN_API __declspec(dllexport)
        #else
            #define MTN_API __declspec(dllimport)
        #endif
    #else
        #define MTN_API 
        #define __stdcall 
    #endif    
#endif

// Ͷ
typedef     unsigned short*     PHAND;
typedef     unsigned short      HAND;
typedef     unsigned int        UInt32;
typedef              int       Int32;
typedef         long  long       Int64;


#define CRD_MAX_DIMENSION 4

//------------------------------------------------------------------------------------------------------------
//
//           ָ
//
//------------------------------------------------------------------------------------------------------------
//  1.ӡر
//  2.
//  3.
//  4.״̬ȡ
//  5.IOƼⲿԴд
//  6.ϵ
//  7.ϵ
//  8.ϵ˶״̬ȡ
//  9.岹˶IO
//  10.
//  11.ӳ
//  12.͹

//------------------------------------------------------------------------------------------------------------
//
//          1.ӡر
//
//------------------------------------------------------------------------------------------------------------
// ͨѶģʽ
typedef enum { USB=0, Ethernet, RS485 } TSearchMode;

//豸Ϣṹ
typedef struct
{
    unsigned short address;     // λϵͳе豸,
    char  idStr[16];            // ʶַ
    char  description[64];      // 
    unsigned short ID;          // ϵID(δ)
}TDevInfo;

// 忨Ѱ
// : mode:ͨѶģʽ
// pDevNo : 豸Ŀ
// pInfoList豸Ϣ
MTN_API short __stdcall NMC_DevSearch( TSearchMode mode, unsigned short *pDevNo, TDevInfo *pInfoList );

// 忨򿪣ţ
// devNo: 豸,ȡֵΧ[0,n] pDevHandle: 豸
MTN_API short __stdcall NMC_DevOpen       ( short devNo, PHAND pDevHandle );

// 忨ر
// pDevHandle : 豸ָ
MTN_API short __stdcall NMC_DevClose(PHAND pDevHandle );

// 忨λ
MTN_API short __stdcall NMC_DevReset(HAND devHandle );

// 򿪵
// devHandle : 豸
// itemNo,ȡֵΧ[0,n]
// pCrdHandleϵ
MTN_API short  __stdcall NMC_MtOpen(HAND devHandle, short itemNo, PHAND pAxisHandle ); 

// رյ
// devHandle : 豸ָ
MTN_API short  __stdcall NMC_MtClose(PHAND pAxisHandle );

// ϵ(ֶ֧ϵ)
// itemNoϵ,ȡֵΧ[0,1]
// pCrdHandleϵ
MTN_API short __stdcall NMC_CrdOpenEx( HAND devHandle,short itemNo, PHAND pCrdHandle );

// رϵ
// pCrdHandleϵ
MTN_API short __stdcall NMC_CrdClose(PHAND pCrdHandle );

//------------------------------------------------------------------------------------------------------------
//
//          2.
//
//------------------------------------------------------------------------------------------------------------
// ϵͳչԴʼID,չģ
#define EXT_RES_START_INDEX  256

// ģʽźԴ,ź,ȡ,,Ƶ 
// Bit7:0 Ƶϵ,ֵΪ0~255ӦƵֵ 1~256
// Bit9:8 źźԴѡ
//   00ⲿź
//   01: 
//   10Զźţ壩
//   11Զźţ壩
// Bit11:10 źͣⲿ
//  00AB,90Ȳ
//  01+
//  10+
//  11
// Bit12 ABⲿ 0,1
// Bit13 Aȡⲿ 0ȡ,1ȡ
// Bit14 Bȡⲿ 0ȡ,1ȡ
// Bti15 ,0Сֵת,1ת
// ñģʽ
// encId: ID,ͨ,ȡֵΧ[0,n],
//                չͨ,256ʾһչͨ,257ʾڶ,Դ
// encMode:ģʽ,ο궨
MTN_API short  __stdcall NMC_SetEncMode( HAND devHandle, short encId,  short encMode );

// λǷֹͣ˶
// enableλ,1Ϊ,0Ϊֹ
MTN_API short  __stdcall NMC_MtSwLmtOnOff  ( HAND axisHandle, short swt );

// λֵ
// posLmtλֵ
// negLmtλֵλΪ
MTN_API short  __stdcall NMC_MtSwLmtValue  ( HAND axisHandle, Int32 posLmt,Int32 negLmt );

//˶ȫ
typedef struct
{
    double estpDec;     // ͣٶ
    double maxVel;      // ٶ
    double maxAcc;      // ٶ
}TSafePara;
// ᰲȫ
// TSafeParaͣٶȡٶȡٶ
MTN_API short  __stdcall NMC_MtSetSafePara( HAND axisHandle, TSafePara *pPara );

// ģʽ
// inv, 1ȡ,0ȡ
// mode 0巽 1
MTN_API short  __stdcall NMC_MtSetStepMode ( HAND axisHandle, short inv, short mode );

// ٶ˲
// עfilterCoefϵ0~5֮,ֵԽ,ٶԽƽĬֵΪ0
MTN_API short __stdcall NMC_MtSetAxisVelFilter(HAND axisHandle,short filterCoef);

// Ӳλ
// posLmtEnable: λ,1Ϊ,0Ϊֹ
// negLmtEnable: λ,1Ϊ,0Ϊֹ
// posLmtSns: λƽ,1Ϊߵƽ,0Ϊ͵ƽ
// negLmtSns: λƽ,1Ϊߵƽ,0Ϊ͵ƽ
MTN_API short __stdcall NMC_MtSetLmtCfg( HAND axisHandle, short posLmtEnable,short negLmtEnable,short posLmtSns,short negLmtSns );

// ŷ
// alarmEnable: ŷ,1Ϊ,0Ϊֹ
// alarmSns:     ŷƽ,1Ϊߵƽ,0Ϊ͵ƽ
MTN_API short __stdcall NMC_MtSetAlarmCfg( HAND axisHandle, short alarmEnable,short alarmSns );

// ˲
// coeϵ Χ0~65535,0˲,ֵԽ˲ЧԽԡ
MTN_API short  __stdcall NMC_MtSetStepFilter ( HAND axisHandle, unsigned short  coe );

//------------------------------------------------------------------------------------------------------------
//
//          3.ָ
//
//------------------------------------------------------------------------------------------------------------
// Ĺ滮ģʽ
#define MT_NONE_PRF_MODE        (-1)            // Ч
#define MT_PTP_PRF_MODE         (0)             // ι滮
#define MT_JOG_PRF_MODE         (1)             // ٶģʽ
#define MT_CRD_PRF_MODE         (3)             // ϵ
#define MT_GANTRY_MODE          (4)             // Ÿģʽ
#define MT_PT_PRF_MODE			(5)				// PTģʽ

// õ滮ģʽ
// mode˶ģʽ
MTN_API short __stdcall NMC_MtSetPrfMode(HAND axisHandle,short mode);

// PTP˶ṹ
typedef struct
{
    double acc;         // ٶ
    double dec;         // ٶ
    double startVel;    // ٶ
    double endVel;      // ֹٶ
    short smoothCoef;   // ƽϵ,ȡֵΧ[0,199]
    short reserved[3];      // 
}TPtpPara;
// ö, ¡
// pAxPara,οṹ塣
MTN_API short __stdcall NMC_MtSetPtpPara( HAND axisHandle, TPtpPara *pAxPara );

// JOG˶ṹ
typedef struct
{
    double acc;         // ٶ
    double dec;         // ٶ
    double smoothCoef;  // ƽϵ,ȡֵΧ[0,199]
}TJogPara;
// Jog˶
// pAxPara,οṹ塣
MTN_API short __stdcall NMC_MtSetJogPara   ( HAND axisHandle, TJogPara *pAxPara );

// Ŀ˶ٶ,ֻPTPJogPTPģʽֻ,Jogģʽűʶ˶
// vel: Ŀٶȣٶȣ,λ /ms
MTN_API short __stdcall NMC_MtSetVel( HAND axisHandle, double vel );

// Ŀ˶λ,ֻPTP
// pos: Ŀλ,λ 
MTN_API short __stdcall NMC_MtSetPtpTgtPos( HAND axisHandle, Int32 pos );

// , ֻPTPJog
MTN_API short __stdcall NMC_MtUpdate( HAND axisHandle );

// ˶ֹͣ
// ע˶ᰴ趨ļٶֹͣ
MTN_API short __stdcall NMC_MtStop( HAND axisHandle );

// ἱͣͣ־λ
// ע˶ᰴ趨ļͣٶֹͣû,ֹͣ
MTN_API short __stdcall NMC_MtAbruptStop( HAND axisHandle );

// λϵͳ,滮Լ
MTN_API short __stdcall NMC_MtZeroPos( HAND axisHandle);

// ŷ״̬
// swt: ÿЧ״̬1, Ч͵ƽ,0,Чߵƽ
MTN_API short  __stdcall NMC_MtSetSvClr( HAND axisHandle, short swt );

// ŷON, ᾲֹʱִ,updateָ,Ҫʱһ
MTN_API short  __stdcall NMC_MtSetSvOn( HAND axisHandle );

// ŷOFF, ᾲֹʱִ,updateָ,Ҫʱһ
MTN_API short  __stdcall NMC_MtSetSvOff( HAND axisHandle );

// ״̬
MTN_API short  __stdcall NMC_MtClrError ( HAND axisHandle );

// ״̬,λ
// stsMask:ӦλΪ1ҪӦλĴ״̬
MTN_API short  __stdcall NMC_MtClrStsByBits(HAND axisHandle , short stsMask);

// λ˶,NMC_MtSetPrfMode,NMC_MtSetPtpPara,NMC_MtSetVel,NMC_MtSetPtpTgtPos,NMC_MtUpdate
// acc:ٶ,decٶ,startVel:ٶ,endVel:ֹٶ,smoothCoef:ƽϵ
// maxVelٶ
// tgtPos:Ŀλ,λ
MTN_API short  __stdcall NMC_MtMovePtpAbs(HAND axisHandle,double acc,double dec,double startVel,double endVel,double maxVel,short smoothCoef,Int32 tgtPos);

// ٶ˶
// acc:ٶ,decٶ,smoothCoef:ƽϵ
// maxVelٶ
// clrStsFlag:Ƿ˶ǰ״̬01
MTN_API short  __stdcall NMC_MtMoveJog(HAND axisHandle,double acc,double dec,double maxVel,
                                        short smoothCoef,short clrStsFlag);
typedef struct
{
	short axisMask;			// 룬ӦbitΪ1ʾ˶
	short clrStsFlag;		// Ƿ˶ǰ״̬01
	short reserved[2];		// 
    double acc[8];			// ٶ
    double dec[8];			// ٶ
    double startVel[8];		// ٶ
    double endVel[8];		// ֹٶ
	double maxVel[8];		// ٶ
	short  smoothCoef[8];	// ƽϵ
	Int32 tgtPos[8];			// λãλ:
}TMovePtpPack8;
// λ˶(˶)
// axisFirstHandle:ĵһ
// pPackData:
// ע⣺1.ĳ޷˶Ĵ״̬᲻˶
MTN_API short  __stdcall NMC_MtMovePtpAbsPack8(HAND axisFirstHandle,TMovePtpPack8 * pPackData);

// λ˶(˶)
// axisFirstHandle:ĵһ
// pPackData:
// ע⣺1.ĳ޷˶Ĵ״̬᲻˶
MTN_API short  __stdcall NMC_MtMovePtpRelPack8(HAND axisFirstHandle,TMovePtpPack8 * pPackData);

// λ˶,˶
// acc:ٶ,decٶ,startVel:ٶ,endVel:ֹٶ,smoothCoef:ƽϵ
// maxVelٶ
// relPos:Եǰλõƶ,λ
MTN_API short  __stdcall NMC_MtMovePtpRel(HAND axisHandle,double acc,double dec,double startVel,double endVel,double maxVel,short smoothCoef,Int32 relPos);


// PTP˶
typedef struct
{ 
    double acc;         // ٶ
    double dec;         // ٶ
    double startVel;    // ٶ
    double endVel;      // յٶ
    double maxVel;      // ٶ
    Int32 tgtPos;        // Ŀλ
    short reserved;      // 
    short smoothCoef;   // ƽϵ
    short inType;       // ͣ0ͨDI1Homeź; 
    short inIdx;       //  źͨ
    short inTrigLevel; // ƽ0͵ƽ1ߵƽ
    short action;       // Ķ01Ŀٶ,
                                                // 2.Ŀλ
                                                // 3:ĿλãλΪԴλã
                                                // 4:ͣ
    double prm1;        // action=1ʱʾµĿٶ
    double prm2;        // action=23ʱʾµĿλ
    double prm3;        // 
    double prm4;        // 
} TPtpTwoStagePrm;

// PTP˶
MTN_API short  __stdcall NMC_MtMovePtpAbsTwoStage(HAND axisHandle,TPtpTwoStagePrm *pPrm);

//------------------------------------------------------------------------------------------------------------
//
//         4.״̬ȡ
//
//------------------------------------------------------------------------------------------------------------
// ȡ滮ϵλ
// pPos : λ,λ 
MTN_API short __stdcall NMC_MtGetPrfPos   ( HAND axisHandle, Int32 *pPos );

// ǰ滮ٶ
// pVel: ٶ,λ /ms
MTN_API short __stdcall NMC_MtGetPrfVel   ( HAND axisHandle, double *pVel );

// ȡ״̬4ᣩ
#define PACK_AXIS_NUM   4
typedef struct
{
    Int32 prfPos[PACK_AXIS_NUM];     // 滮λ
    Int32 encPos[PACK_AXIS_NUM];     // ʵλ
    float prfVel[PACK_AXIS_NUM];    // 滮ٶ
    Int32 motionIO[PACK_AXIS_NUM];   // רIO
    short sts[PACK_AXIS_NUM];       // ״̬
    Int32 gpo;                       // ͨ
    Int32 gpi;                       // ͨ
}TAxisStsPack;
// ȡ״̬,ӵһῪʼȡĸ״̬
// axisFirstHandle : һ
// count:ȡ״̬,ȡֵΧ[1,4]
// pPackSts: ״̬,οṹ嶨
MTN_API short  __stdcall NMC_MtGetStsPack  ( HAND axisFirstHandle, short count,TAxisStsPack *pPackSts );

// ȡ״̬12ᣩ
typedef struct
{
    short          mtSts[12];          // ״̬λοNMC_MtGetSts
    short          mtMio[12];          // רIO,λοNMC_MtGetMotionIO
    short          mtMioLog[12];       // רIO:߼ƽ,λοNMC_MtGetMotionIOLogical
	Int32           mtPrfPos[12];       // 滮λ
    Int32           mtEncPos[12];       // ʵλ
	float          mtPrfVel[12];       // 滮ٶ

    short          crdSts[2];          // ϵ״̬
	float          crdPrfVel[2];	   // ϵ˶ٶ
	Int32           crdUserSeg[2];      // ϵеĻκ
	Int32           crdFreeSpace[2];    // ϵʣռ
    Int32           crdUsedSpace[2];    // ϵʹÿռ

    Int32           gpi;                // ͨ
    Int32           gpo;                // ͨ
    Int32           crdLeftLen[2];      // ϵʣγλ:
    Int32           crdAllCmdCnt[2];    // ϵܹѹָĿ
    Int32           extDi[6];           // չģ룬2վ~8վ
    Int32           extDo[6];           // չģ2վ~8վ
    short		   adc[4];			   // ģֵ 0~4ͨ
    short		   adcAux[2];		   // չģֵ 0~1ͨ
    short		   dac[4];			   // ģֵ 0~4ͨ
    short		   dacAux[2];		   // չģֵ 0~1ͨ
    Int32           reserved[10];       // Ԥ

}TAxisStsPack12Ex;
// ȡ12״̬
// axisFirstHandle : һ
// pPackSts: ״̬,οṹ嶨
MTN_API short  __stdcall NMC_MtGetStsPack12Ex  ( HAND axisFirstHandle, TAxisStsPack12Ex *pPackSts );

// ǰͨ
// pPos:رֵ
MTN_API short  __stdcall NMC_MtGetEncPos   ( HAND axisHandle, Int32 *pPos );

// ٶ(λǣ/ms)
MTN_API short  __stdcall NMC_GetEncVel( HAND devHandle, short encId, double *pVel);

// ״̬λ 
#define BIT_AXIS_BUSY           (0x00000001)    // bit 0  , ˶:1 ,ֹ 0       
#define BIT_AXIS_POSREC         (0x00000002)    // bit 1 , ŷλõ,ģʽʱλõ,ŷģʽʱʵλõ 
#define BIT_AXIS_MVERR          (0x00000004)    // bit 2 , ϴ˶,ǰ޷˶,Ҫλ 
#define BIT_AXIS_SVON           (0x00000008)    // bit 3  , ŷ        
#define BIT_AXIS_CRD            (0x00000010)    // bit 4 , ϵģʽ      
#define BIT_AXIS_STEP           (0x00000020)    // bit 5  , /ŷ       
#define BIT_AXIS_LMTP           (0x00000040)    // bit 6  , λ        
#define BIT_AXIS_LMTN           (0x00000080)    // bit 7  , λ        
#define BIT_AXIS_SOFTPOSLMT     (0x00000100)    // bit 8  , λ  
#define BIT_AXIS_SOFTNEGLMT     (0x00000200)    // bit 9  , λ  
#define BIT_AXIS_ALM            (0x00000400)    // bit 10  , ŷ,Ҫλ 
#define BIT_AXIS_POSERR         (0x00000800)    // bit 11  , λó,Ҫλ 
#define BIT_AXIS_ESTP           (0x00001000)    // bit 12 , ͣ,Ҫλ 
#define BIT_AXIS_HWERR          (0x00002000)    // bit 13 , Ӳ 
#define BIT_AXIS_CAPTSET        (0x00004000)    // bit 14  , 񴥷       
// ǰ״̬
// pStsWord: ״̬֡ολ
MTN_API short  __stdcall NMC_MtGetSts( HAND axisHandle, short *pStsWord );

// רIO,arrive,alm : home : limit+ , limit- 
#define BIT_AXMTIO_LMTN     (0x00000001)    // bit 0  ,λ  
#define BIT_AXMTIO_LMTP     (0x00000002)    // bit 1  ,λ  
#define BIT_AXMTIO_HOME     (0x00000004)    // bit 2  ,ԭ  
#define BIT_AXMTIO_ALARM    (0x00000008)    // bit 3  , 
#define BIT_AXMTIO_ARRIVE   (0x00000010)    // bit 4  ,λ 
// ˶רIO
// pIoValue : רIO״̬,ԭ,λ,ολ塣ӦλΪ0Ϊ͵ƽ,1Ϊߵƽ
MTN_API short __stdcall NMC_MtGetMotionIO ( HAND axisHandle, Int32 *pIoValue );

// ˶רIO,߼ƽ
// pIoValue : רIO״̬,ԭ,λ,ολ塣ӦλΪ0Ϊ͵ƽ,1Ϊߵƽ
MTN_API short __stdcall NMC_MtGetMotionIOLogical ( HAND axisHandle, Int32 *pIoValue );

//------------------------------------------------------------------------------------------------------------
//
//        5.IOƼⲿԴд
//
//------------------------------------------------------------------------------------------------------------
// ͨ(ͨ,ֳ֧32λ),Ĭgroup
// value: ͨ1, ߵƽ,0,͵ƽ
// groupID:DO,ȡֵΧ[0,n],ҪǷڶ
MTN_API short  __stdcall NMC_SetDOGroup( HAND devHandle, Int32 value, short groupID) ;

// ͨ(ͨ,ֳ֧32λ) ,Ĭgroup
// pInValue: ֵͨ1, ߵƽ,0,͵ƽ
// groupID:DI,ȡֵΧ[0,n],0: DI31~DI0, 1: DI63~DI32,ָչIOģ
MTN_API short __stdcall NMC_GetDIGroup( HAND devHandle, Int32 *pInValue, short groupID);

// ȡͨ(ͨ,ֳ֧32λ),Ĭgroup
// pDoValue: ͨ1, ߵƽ,0,͵ƽ
// groupID:DO,ȡֵΧ[0,n],,0: DO31~DO0, 1: DO63~DO32,ָչIOģ
MTN_API short  __stdcall NMC_GetDOGroup( HAND devHandle, Int32 *pDoValue, short groupID);

// λͨ
// bitIndex:ȡֵΧ[0,n],λ,ǰ64λΪصͨ,64ΪչDO
// value: ͨ1, ߵƽ,0,͵ƽ
MTN_API short  __stdcall NMC_SetDOBit( HAND devHandle, short bitIndex, short value );

// λͨ 
// ͨ(ͨ,ֳ֧32λ) 
// bitIndex:ȡֵΧ[0,n],λ
// pBitValue: ֵͨ1, ߵƽ,0,͵ƽ
MTN_API short  __stdcall NMC_GetDIBit( HAND devHandle,short bitIndex, short *pBitValue );

// ȡչIOģ״̬
// sts:ioģ״̬
MTN_API short  __stdcall NMC_GetIOModuleSts(HAND devHandle, UInt32 *sts);

// չIOģЧĬΪIO64ģ飩
// chDevId:豸ID
MTN_API short  __stdcall NMC_SetIOModuleEn( HAND devHandle, unsigned char chDevId);

// չģͶ
#define IOMODULE_TYPE_IO64		1		// 32DI32DOģ飨16DI16DOģ飩
#define IOMODULE_TYPE_IO32_DA	2		// 4AD4DAģ

// չIOģЧ(ģ)
// chDevId:豸ID
// chDevType:ģͣ궨
MTN_API short  __stdcall NMC_IOModuleSetEn( HAND devHandle, unsigned char chDevId,short chDevType);

// ȡչIOģ
// chDevId:豸ID
// pChDevType:صģͣ궨
MTN_API short  __stdcall NMC_IOModuleGetType( HAND devHandle, unsigned char chDevId,short *pChDevType);

// չIOģͨд8λ
// chDevId豸վ
// offset:ƫ
MTN_API short  __stdcall NMC_IOModuleWr8Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,unsigned char data);

// չIOģͨд16λ
MTN_API short  __stdcall NMC_IOModuleWr16Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,unsigned short data);

// չIOģͨд32λ
MTN_API short  __stdcall NMC_IOModuleWr32Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,UInt32 data);

// չIOģͨ8λ
// chDevId豸վ
// offset:ƫ
MTN_API short  __stdcall NMC_IOModuleRdOut8Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,unsigned char *pData);

// չIOģͨ16λ
MTN_API short  __stdcall NMC_IOModuleRdOut16Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,unsigned short *pData);

// չIOģͨ32λ
MTN_API short  __stdcall NMC_IOModuleRdOut32Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,UInt32 *pData);

// չIOģͨ8λ
// chDevId豸վ
// offset:ƫ
MTN_API short  __stdcall NMC_IOModuleRd8Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,unsigned char *pData);

// չIOģͨ16λ
MTN_API short  __stdcall NMC_IOModuleRd16Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,unsigned short *pData);

// չIOģͨ32λ
MTN_API short  __stdcall NMC_IOModuleRd32Bit( HAND devHandle, unsigned char chDevId,unsigned char offset,UInt32 *pData);


//------------------------------------------------------------------------------------------------------------
//
//        6.ϵ
//
//------------------------------------------------------------------------------------------------------------
// ϵ
typedef struct
{
    short axCnts;       // 
    short reserved[3];  // 
    short pAxArray[4];  // ϵӳ,ȡֵΧ[0,n]
    short port[4];      // ϵ˿ӳ,ͳһΪ0
}TCrdConfig;
// 岹ϵϵͳ()
// pConfig:ϵ,οṹ嶨
MTN_API short __stdcall NMC_CrdConfig( HAND crdHandle, TCrdConfig *pConfig );

//˶ȫ
typedef struct
{
    double estpDec;     // ͣٶ
    double maxVel;      // ٶ
    double maxAcc;      // ٶ
}TCrdSafePara;
// Ỻ˶ȫ
// pParaͣٶȡٶȡٶ
MTN_API short  __stdcall NMC_CrdSetSafePara( HAND crdHandle, TCrdSafePara *pPara );

// Ỻ˶ƫ
// count:ƫƵ
// pOffsetArray˶ƫ,Int32 
// עͬʱ޸ϵ˶ƫƣ
MTN_API short  __stdcall NMC_CrdSetOffset( HAND crdHandle,short count, Int32 *pOffsetArray );

// ɾϵ
MTN_API short __stdcall NMC_CrdDelete(  HAND crdHandle );


//------------------------------------------------------------------------------------------------------------
//
//        7.ϵп
//
//------------------------------------------------------------------------------------------------------------
// ϵ˶  
MTN_API short __stdcall NMC_CrdStartMtn( HAND crdHandle );

// ƽֹͣ˶
// עֹͣ˶ָҪٴܼлָ
MTN_API short __stdcall NMC_CrdStopMtn( HAND crdHandle );

// ͣ
// ָ
MTN_API short __stdcall NMC_CrdEstopMtn( HAND crdHandle );

// ˶ȴ˶Ž˶,ÿб־
// ע˶ֹͣ˶ָȫִ,˶״̬
MTN_API short __stdcall NMC_CrdEndMtn   ( HAND crdHandle );

// ػ˶Ķϵ
// vel:ʱʹõٶ
// acc:ʱʹõļٶ
MTN_API short __stdcall NMC_CrdGotoBreak( HAND crdHandle,double acc,double vel);


//------------------------------------------------------------------------------------------------------------
//
//        8.ϵ˶״̬ȡ
//
//------------------------------------------------------------------------------------------------------------
// ϵ״̬λ 
#define BIT_CORD_BUSY           (0x00000001)    // bit 0 , ˶:1 ,ֹ 0,˶˶ֹͣ, 
#define BIT_CORD_MVERR          (0x00000002)    // bit 1 , ˶,ǰ˶ָ޷,Ҫλ    
#define BIT_CORD_EMPTY          (0x00000004)    // bit 2 , ա       
#define BIT_CORD_FULL           (0x00000008)    // bit 3 ,                
#define BIT_CORD_NODATASTOP     (0x00000010)    // bit 4 , 쳣ֹͣ߼ͣ    
#define BIT_CORD_SDRAM_HWERR    (0x00000020)    // bit 5, 岹Ӳ  
// ȡϵ״̬
// pStsWord״̬,ο궨
MTN_API short __stdcall NMC_CrdGetSts( HAND crdHandle, short  *pStsWord );

typedef struct
{
    short crdSts;          // ϵ״̬
    short axSts[4];        // ϵ״̬
    Int32  prfPos[4];       // ûϵµĹ滮λ
    Int32  axisPos[4];      // еϵµĹ滮λ
    Int32  encPos[4];        // λ
    Int32  userSeg;         // еĻκ
    double  prfVel;         // ˶ٶ
    Int32  gpDi;             // ͨ0~31
    Int32  gpDo;             // ͨ0~31
    short  motDi[4];        // λԭ㡢οרIOλ(  BIT_AXMTIO_LMTN )
    short  reserved;        // 
    Int32 crdFreeSpace;      // ʣռ
    Int32 crdUsedSpace;
}TPackedCrdSts4;
// ϵ˶ģʽ,ȡ״̬
MTN_API short __stdcall NMC_CrdGetStsPack4( HAND crdHandle, TPackedCrdSts4 *pPackSts );

// ϵ˶״̬,ͬʱĴ״̬
MTN_API short __stdcall NMC_CrdClrError   ( HAND crdHandle );

// ϵٶȱ
// overRideϵٶȱ,ȡֵΧ(0,10)
MTN_API short __stdcall NMC_CrdSetOverRide( HAND crdHandle, double overRide );

// ȡָг
// pResؿеĳ
MTN_API short __stdcall NMC_CrdBufGetFree ( HAND crdHandle, Int32 *pRes );

// ȡָó
// pLen: ȡлδִеָ
MTN_API short __stdcall NMC_CrdBufGetUsed  ( HAND crdHandle, Int32 *pLen );

// ȡ岹δɵλ
// pLen: 
MTN_API short __stdcall NMC_CrdGetBufLeftLength(HAND crdHandle, double *pLen);

// ָ
MTN_API short __stdcall NMC_CrdBufClr( HAND crdHandle );

// ϵʣλڿƼĹرղ
MTN_API short  __stdcall NMC_SetCrdLeftLenForLaserWaveOff ( HAND crdHandle,double length );

// κ
// pSegNoصĵǰκ
MTN_API short __stdcall NMC_CrdGetUserSegNo  ( HAND crdHandle, Int32 *pSegNo);

//  ȡܹѹ˶ָ
//  pCnt:صָ
MTN_API short __stdcall NMC_CrdGetBufAllCmdCnt ( HAND crdHandle, Int32 *pCnt);

// ʼ㻺ִʱ
// ע:1.Ҫִʱ䣬Ҫʹλǰհ
//     2.ʼеĻָѹ
MTN_API short __stdcall NMC_CrdStartExeTimeCalc(void);

// ȡִָʱ䣬ֹͣ㣬λ:ms
MTN_API short __stdcall NMC_CrdGetExeTime(double *pTime);

//------------------------------------------------------------------------------------------------------------
//
//        9.岹˶IO
//
//------------------------------------------------------------------------------------------------------------

// ֱ߲岹
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// mask:,λʾ
// endVel,vel,synAcc:յٶȣٶȣ岹ٶ
// pTgPosArrayĿλ
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdLineXYZA(  HAND crdHandle,  Int32 segNo, short mask,
	Int32 *pTgPosArray, double endVel, double vel,double synAcc ,short lookaheadDis);

// 4ά岹£AתٶȣڸٶȣҪнٴ
MTN_API short  __stdcall NMC_CrdSetFourthAxisTolTurnVel(HAND crdHandle,double tolVel);

// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// mask:,λʾ
// pTgPosArrayĿλ,Ϊ3
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdLineXYZEx(  HAND crdHandle,  Int32 segNo, short mask,Int32 *pTgPosArray,
	double endVel, double vel,double synAcc,short lookaheadDis );

// ֱ߲岹֧8ᣩ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// crdAxmask:ϵв,λʾ
// extAxmask:,λʾ,ܰϵ
// pTgPosArrayĿλ,Ϊв˶,
//              Сϵڵ꣨crdAxMaskλУ꣨extAxMaskλУ
// lookaheadDis:Ƿʹǰհ(ϵе˶),0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdLineXYZD8(  HAND crdHandle, Int32 segNo, 
	Int32 crdAxmask, Int32 extAxmask, Int32 *pTgPosArray,
	double endVel, double vel,double synAcc,short lookaheadDis );

// 8岹Ԫṹ
typedef struct
{
    Int32 segNo;         // ûԶκ
	short crdAxMask;
	short extAxMask;
    Int32  tgPos[8];     // Ŀλ
	float vel;         // ٶ
	float endVel;      // յٶ
    float acc;			// 岹ٶ
	short lookaheadDis;	// Ƿʹǰհ
	short reserved;		// 
}TCrdLineXYZD8Unit;

// Ķֱ߲岹
// count:ָ,ȡֵΧ[1,18]
// pCmdArray:ָб
MTN_API short __stdcall NMC_CrdLineXYZD8Pack(  HAND crdHandle, short count,  TCrdLineXYZD8Unit *pCmdArray);


// 4岹Ԫṹ
typedef struct
{
    Int32 segNo;         // ûԶκ
	short crdAxMask;
	short extAxMask;
    Int32  tgPos[4];     // Ŀλ
	float vel;         // ٶ
	float endVel;      // յٶ
    float acc;      // 岹ٶ
	short lookaheadDis;	// Ƿʹǰհ
	short reserved;		// 
}TCrdLineXYZD4Unit;

// 4ֱ߲岹
// count:ָ,ȡֵΧ[1,25]
// pCmdArray:ָб
MTN_API short __stdcall NMC_CrdLineXYZD4Pack(  HAND crdHandle, short count,  TCrdLineXYZD4Unit *pCmdArray);

typedef struct
{
    Int32 segNo;         // ûԶκ
    Int32  tgPos[3];     // Ŀλ
    double endVel;      // յٶ
    double vel;         // ٶ
    double synAcc;      // 岹ٶ
    short mask;         // ,λʾ
	short lookaheadDis;	// Ƿʹǰհ
    short reserved[2];  // 
}TCrdLineXYZUnit;
// ֱ߲岹
// count:ָ,ȡֵΧ[1,20]
// pCmdArray:ָб
MTN_API short __stdcall NMC_CrdLineXYZPack(  HAND crdHandle, short count,  TCrdLineXYZUnit *pCmdArray);

// XYƽԲ岹յλá뾶
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// radius:Բ뾶,0ʾӻ,С0ʾŻ
// pTgPosArrayĿλ飨ά,ֱʾXYλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdArcRadius(  HAND crdHandle, Int32 segNo,Int32 *pTgPosArray, double radius, short circleDir,double endVel, double vel,double synAcc );

// YZƽԲ岹յλá뾶
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// radius:Բ뾶,0ʾӻ,С0ʾŻ
// pTgPosArrayĿλ飨ά,ֱʾYZλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdArcRadiusYZ(  HAND crdHandle, Int32 segNo,
	Int32 *pTgPos, double radius, short circleDir,double velEnd, double vel,double synAcc );

// ZXƽԲ岹յλá뾶
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// radius:Բ뾶,0ʾӻ,С0ʾŻ
// pTgPosArrayĿλ飨ά,ֱʾZXλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdArcRadiusZX(  HAND crdHandle, Int32 segNo,
	Int32 *pTgPos, double radius, short circleDir,double velEnd, double vel,double synAcc );

// XYƽԲ岹յλá뾶
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// radius:Բ뾶,0ʾӻ,С0ʾŻ
// pTgPosArrayĿλ飨ά,ֱʾXYλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcRadiusEx(  HAND crdHandle, Int32 segNo,Int32 *pTgPosArray, double radius, 
								short circleDir,double endVel, double vel,double synAcc ,short lookaheadDis);

// YZƽԲ岹յλá뾶
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// radius:Բ뾶,0ʾӻ,С0ʾŻ
// pTgPosArrayĿλ飨ά,ֱʾYZλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcRadiusYZEx(  HAND crdHandle, Int32 segNo,Int32 *pTgPos, double radius, 
	short circleDir,double velEnd, double vel,double synAcc ,short lookaheadDis);

// ZXƽԲ岹յλá뾶
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// radius:Բ뾶,0ʾӻ,С0ʾŻ
// pTgPosArrayĿλ飨ά,ֱʾZXλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcRadiusZXEx(  HAND crdHandle, Int32 segNo,Int32 *pTgPos, double radius, 
	short circleDir,double velEnd, double vel,double synAcc ,short lookaheadDis);

// XYƽԲ岹յλáԲġ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosArray:Բ꣨ά,ֱʾXYԲλã,ע⣺ԲΪλ
// pTgPosArrayĿλãά,ֱʾXYĿλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdArcCenter(  HAND crdHandle, Int32 segNo,Int32 *pTgPosArray, Int32 *pCenterPosArray,short circleDir,double endVel, double vel,double synAcc );

// YZƽԲ岹յλáԲġ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosArray:Բ꣨ά,ֱʾYZԲλã,ע⣺ԲΪλ
// pTgPosArrayĿλãά,ֱʾYZĿλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdArcCenterYZ(  HAND crdHandle, Int32 segNo,Int32 *pTgPos, 
	Int32 *pCenterPos,short circleDir,double velEnd, double vel,double synAcc );

// ZXƽԲ岹յλáԲġ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosArray:Բ꣨ά,ֱʾZXԲλã,ע⣺ԲΪλ
// pTgPosArrayĿλãά,ֱʾZXĿλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdArcCenterZX(  HAND crdHandle, Int32 segNo,Int32 *pTgPos, 
	Int32 *pCenterPos,short circleDir,double velEnd, double vel,double synAcc );

// XYƽԲ岹յλáԲġ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosArray:Բ꣨ά,ֱʾXYԲλã,ע⣺ԲΪλ
// pTgPosArrayĿλãά,ֱʾXYĿλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcCenterEx(  HAND crdHandle, Int32 segNo,Int32 *pTgPosArray, Int32 *pCenterPosArray,
										short circleDir,double endVel, double vel,double synAcc ,short lookaheadDis);

// YZƽԲ岹յλáԲġ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosArray:Բ꣨ά,ֱʾZXԲλã,ע⣺ԲΪλ
// pTgPosArrayĿλãά,ֱʾYZĿλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcCenterYZEx(  HAND crdHandle, Int32 segNo,Int32 *pTgPos, Int32 *pCenterPos,
    short circleDir,double velEnd, double vel,double synAcc ,short lookaheadDis);

// ZXƽԲ岹յλáԲġ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosArray:Բ꣨ά,ֱʾZXԲλã,ע⣺ԲΪλ
// pTgPosArrayĿλãά,ֱʾZXĿλã
// circleDir:Բ,0ʾ˳ʱ뷽,1ʾʱ뷽
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcCenterZXEx(  HAND crdHandle, Int32 segNo,Int32 *pTgPos, Int32 *pCenterPos,
    short circleDir,double velEnd, double vel,double synAcc ,short lookaheadDis);

// XYƽԲ岹㣨ǰ㣩е㡢յ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pMidPosArray:мλõ꣨ά,ֱʾмXYλã
// pTgPosArrayյλ꣨ά,ֱʾյXYλã
MTN_API short __stdcall NMC_CrdArcPPP(  HAND crdHandle,Int32 segNo, Int32 *pMidPosArray, Int32 *pTgPosArray, double endVel, double vel,double synAcc );

// XYƽԲ岹㣨ǰ㣩е㡢յ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pMidPosArray:мλõ꣨ά,ֱʾмXYλã
// pTgPosArrayյλ꣨ά,ֱʾյXYλã
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArcPPPEx(  HAND crdHandle,Int32 segNo, Int32 *pMidPosArray, Int32 *pTgPosArray, 
												double endVel, double vel,double synAcc ,short lookaheadDis);
// Բ岹ĬϲٶǰհʼֹٶΪ0ע⣡ԲΪԲ
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pCenterPosԲԲĵλãά,ֱʾеXYλãע⣡λõԲλΪ
// abRatio:ʾԲABĳȱֵ ֵΧ[0.05,1]
// ellipseDir:Բ滭,0ʾ˳ʱ뷽,1ʾʱ뷽
MTN_API short __stdcall NMC_CrdEllipse(  HAND crdHandle, Int32 segNo,double abRatio, Int32 *pCenterPos,short ellipseDir, double vel,double synAcc);

// ߲岹
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pTgPosArrayĿλãά,ֱʾյXYZλã
// pCenterPosArray:Բλãά,ֱʾXYԲλã,ע⣺ԲΪλ
// rounds: ZȦ
MTN_API short __stdcall NMC_CrdHelixCenter(  HAND crdHandle, Int32 segNo, Int32 *pTgPosArray, Int32 *pCenterPosArray,short circleDir,double rounds, double endVel, double vel,double synAcc );

// ߲岹
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pTgPosArrayĿλãά,ֱʾյXYZλã
// pCenterPosArray:Բλãά,ֱʾXYԲλã,ע⣺ԲΪλ
// rounds: ZȦ
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdHelixCenterEx(  HAND crdHandle, Int32 segNo, Int32 *pTgPosArray, Int32 *pCenterPosArray,short circleDir,
														double rounds, double endVel, double vel,double synAcc ,short lookaheadDis);

// 3DԲ岹
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pMidPosеλãά,ֱʾеXYZλã
// pTgPos:յλãά,ֱʾյXYZλã
MTN_API short __stdcall NMC_CrdArc3D(  HAND crdHandle,Int32 segNo, Int32 *pMidPos, Int32 *pTgPos,
									double velEnd, double vel,double synAcc );

// 3DԲ岹
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pMidPosеλãά,ֱʾеXYZλã
// pTgPos:յλãά,ֱʾյXYZλã
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdArc3DEx(  HAND crdHandle,Int32 segNo, Int32 *pMidPos, Int32 *pTgPos,
									double velEnd, double vel,double synAcc ,short lookaheadDis);

// 3DԲ岹(Բ)
// segNo:κţendVel:յٶ;vel:ٶ;synAcc:ϳɼٶ
// pMidPosеλãά,ֱʾеXYZλã
// pTgPos:յλãά,ֱʾյXYZλã
// lookaheadDis:Ƿʹǰհ,0ʹǰհ,Զյٶ,1ǰհ,ʹ趨յٶȣendVel
MTN_API short __stdcall NMC_CrdCircle3DEx(  HAND crdHandle,Int32 segNo, Int32 *pMidPos, Int32 *pTgPos,
									double velEnd, double vel,double synAcc ,short lookaheadDis);

// DO鶨
#define CRD_BUFF_DO_MOTOR_ENABLE            1   // ʹ
#define CRD_BUFF_DO_MOTOR_CLEAR             2   // 
#define CRD_BUFF_DO_GPDO1                   3   // ͨ1
#define CRD_BUFF_DO_GPDO2                   4   // ͨ2
#define CRD_BUFF_DO_EXTDO1					5	// չģ1
#define CRD_BUFF_DO_EXTDO2					6	// չģ2
#define CRD_BUFF_DO_EXTDO3					7	// չģ3
#define CRD_BUFF_DO_EXTDO4					8	// չģ4
#define CRD_BUFF_DO_EXTDO5					9	// չģ5
#define CRD_BUFF_DO_EXTDO6					10	// չģ6

// DO
// segNo:κ
// doType:Do,궨
// chλ,ȡֵΧ[0,31]
// valueֵ,ȡֵΧ[0,1]
MTN_API short __stdcall NMC_CrdBufDo( HAND crdHandle, Int32 segNo, short doType,   Int32  ch,  Int32  value);

// DO
// segNo:κ
// gourp:Do,궨
// doMaskλ
// doValueֵ
MTN_API short  __stdcall NMC_CrdBufDoEx(HAND crdHandle,Int32 segNo,short group,Int32 doMask,Int32 doValue);

// ͨ
#define BUF_OUT_GROUP_DA        (0)             // ģ
#define BUF_OUT_GROUP_PWM       (1)             // PWM
// 
// segNo:κ
// gourp:,궨
// chͨ,ȡֵΧ[0,n]
// valueֵ
MTN_API short __stdcall NMC_CrdBufOut( HAND crdHandle,  Int32 segNo, short group, short ch, Int32  value);

// DIȴ
// index:ͨ,ȡֵΧ[0,127],ǰ64ͨͨDI64ͨչIO
// diValueȴֵ
// waitLastTimeʱ,λ
MTN_API short __stdcall NMC_CrdBufWaitDI(HAND crdHandle, Int32 segNo,short index,short diValue,Int32 waitLastTime);

// :ȴ˶λ
// segNo:κ
// axisMask:Ҫȴλ루λӦ,ܳ
// overTime:ȴλʱʱ䣬λms
MTN_API short  __stdcall NMC_CrdBufWaitEncInPosition(HAND crdHandle,Int32 segNo,Int32 axisMask,Int32 overTime);

// :ȴضλãִһָ
// segNo:κ
// axisNo:Ҫȴλ
// condition:λ0Сڵ趨λ  1ڵ趨λ
// pos:趨λ
// posSrc:ȴ滮Ǳ0 1ڲ滮
// overTime:ȴλʱʱ䣬λms
MTN_API short  __stdcall NMC_CrdBufWaitPos(HAND crdHandle,Int32 segNo,short axisNo,
    short condition,Int32 pos,short posSrc,Int32 overTime);

// ʱλ
#define CRD_BUFF_DELAY_SCALE_MS             0   // 
#define CRD_BUFF_DELAY_SCALE_SECAND         1   // 
// ʱ
// segNo:κ
// scale:ʱλ,0ʾλΪ,1ʾλΪ
// countʱʱ
MTN_API short __stdcall NMC_CrdBufDelay( HAND crdHandle, Int32 segNo, short scale, Int32  count);

// ƶ(λƶ)
// segNo:κ
// axMask:
// pTgPosĿλ
// blockEn:ǷΪģʽ
// synEnǷΪͬģʽ,synEnblockEnͬʱΪ1,ͬ
MTN_API short __stdcall NMC_CrdBufAxMove( HAND crdHandle,  Int32 segNo, short axMask,Int32 *pTgPos,short blockEn ,short synEn);

// ƶ()
// segNo:κ
// axMask:
// pTgPosĿλ
// vel:ٶ
// acc:ٶ
// blockEn:ǷΪģʽ
// synEnǷΪͬģʽ,synEnblockEnͬʱΪ1,ͬ
MTN_API short  __stdcall NMC_CrdBufAxMoveEx(HAND crdHandle,Int32 segNo,short axMask,Int32 *pTgPos,
	double vel,double acc,short blockEn ,short synEn);

// ƶ(λƶ)
// segNo:κ
// axMask:
// pRelPosƶλ
// blockEn:ǷΪģʽ
// synEnǷΪͬģʽ,synEnblockEnͬʱΪ1,ͬ
MTN_API short __stdcall NMC_CrdBufAxMoveRel( HAND crdHandle,  Int32 segNo, short axMask,Int32 *pRelPos,short blockEn ,short synEn);

// ƶ
// segNo:κ
// axis,[0,n]
// vel:˶ٶ
// acc:˶ٶ
// smoothCoef:ƽϵ
MTN_API short __stdcall NMC_CrdBufSetPtpMovePara(HAND crdHandle, Int32 segNo,short axis,double vel,double acc,short soomthCoef);

// 
// segNo:κ
// onOff:
MTN_API short __stdcall NMC_CrdBufValueFollow ( HAND crdHandle ,  Int32 segNo, short onOff );


//------------------------------------------------------------------------------------------------------------
//
//        10.
//
//------------------------------------------------------------------------------------------------------------
// Ͷ                                                 
// ģʽ    ԭ      λ     Z    ԭ+Z ԭ+ -Z  λ+ -Z
typedef enum { HM_MODE1=0, HM_MODE2, HM_MODE3, HM_MODE4, HM_MODE5, HM_MODE6 } THomeMode;

// 
typedef struct
{
    short  mode;                    // ģʽ,HM_MODE1 ~ HM_MODE6 룩
    short  dir;                     // Ѱ㷽򣨱룩, 0:,1,ֵ
    Int32    offset;                 // ԭƫƣ룩
    double  scan1stVel;             // Ѱٶȣ룩
    double  scan2ndVel;             // ٣ѰʱҪ
    // usePreSetPtpPara=0ʱ,˶ļٶĬϵacc,ٶȡյٶȡƽϵĬΪ0
    double  acc;                    // ٶ
    
    unsigned char reScanEn;         // ǷѰ㣨ѡ,ʱΪ0
    unsigned char homeEdge;         // ԭ,أĬ½أ
    unsigned char lmtEdge;          // λ,أĬ½أ
    unsigned char zEdge;            // λ,أĬ½أ
    UInt32 iniRetPos;        // ʼ˶루ѡ,ʱΪ0
    UInt32 retSwOffset;      // ˶ʱ뿪ؾ루ѡ,ʱΪ0
    UInt32 safeLen;          // ȫ,ʱԶѰ루ѡ,ʱΪ0,ƾ룩
    unsigned char usePreSetPtpPara; // Ϊ1ʾûҪǰ,Լû˶㵽㣩Ĳ
    unsigned char reserved[3];      // 
    Int32 reserved2;                 // 
} THomeSetting;
// û
// pHomePara: ṹ,οṹ
MTN_API short __stdcall NMC_MtSetHomePara( HAND axisHandle, THomeSetting *pHomePara );

// ״̬λ 
#define BIT_AXHOME_BUSY         (0x00000001)    // bit 0  , æ    
#define BIT_AXHOME_OK           (0x00000002)    // bit 1  , ɹ  
#define BIT_AXHOME_FAIL         (0x00000004)    // bit 2  , ʧ  
#define BIT_AXHOME_ERR_MV       (0x00000008)    // bit 3  , ˶² 
#define BIT_AXHOME_ERR_SWT      (0x00000010)    // bit 4  , Ѱпû 
// ״̬
// pStsWord: ״̬֡궨,8λΪ
MTN_API short __stdcall NMC_MtGetHomeSts(HAND axisHandle, short *pStsWord );

// 
MTN_API short __stdcall NMC_MtHome(HAND axisHandle );

// Ի㣨Ի,λã
MTN_API short __stdcall NMC_MtTryHome( HAND axisHandle );

// ֹ
MTN_API short __stdcall NMC_MtHomeStop(HAND axisHandle );

// »λúʷλõĲֵ
// pErrPos: λƫ
// עɹʱ
MTN_API short __stdcall NMC_MtGetHomeError( HAND axisHandle, Int32 *pErrPos );


//------------------------------------------------------------------------------------------------------------
//
//        11.ӳ
//
//------------------------------------------------------------------------------------------------------------
// Gear淽
// dir  0:˫棬<0棬 >0
MTN_API short  __stdcall NMC_MtGearSetDir(HAND axisHandle,short dir);

// ȡGear淽
// pDir  0:˫棬<0棬 >0
MTN_API short  __stdcall NMC_MtGearGetDir(HAND axisHandle,short *pDir);

// Gear
// axisHandle
// masterNo  кţ0~N
// masterType    1:AXIS滮ֵ  2AXISֵ 3ֵ
MTN_API short  __stdcall NMC_MtGearSetMaster(HAND axisHandle,short masterNo,short masterType);

// ȡGear
// pMasterNo  кţ0~N
// pMasterType  
MTN_API short  __stdcall NMC_MtGearGetMaster(HAND axisHandle,short *pMasterNo,short *pMasterType);

// Gear汶
// axisHandle
// masterEven ϵλ
// slaveEven  ϵλ
// masterSlopeλ,0ͬʱܵ1
MTN_API short  __stdcall NMC_MtGearSetRatio(HAND axisHandle,Int32 masterEven,Int32 slaveEven,Int32 masterSlope);

// ȡGear汶
// axisHandle
// pMasterEven ϵλ
// pSlaveEven  ϵλ
// pMasterSlopeλ,0ͬʱܵ1
MTN_API short  __stdcall NMC_MtGearGetRatio(HAND axisHandle,Int32 *pMasterEven,Int32 *pSlaveEven,Int32 *pMasterSlope);

// Gear˶
// syncCount axisHandle ͬ
// pSyncAxisArray: ͬţ0~N
// עͬͬһ
MTN_API short  __stdcall NMC_MtGearStartMtn(HAND axisHandle,short syncAxCnts,short *pSyncAxArray);


//------------------------------------------------------------------------------------------------------------
//
//        12.͹
//
//------------------------------------------------------------------------------------------------------------
// FOLLOW淽
// dir  0:˫棬<0棬 >0
MTN_API short  __stdcall NMC_MtFollowSetDir(HAND axisHandle,short dir);

// ȡFOLLOW淽
// pDir  0:˫棬<0棬 >0
MTN_API short  __stdcall NMC_MtFollowGetDir(HAND axisHandle,short *pDir);

// FOLLOW
#define PROFILE_FOLLOW_MASTER_NONE		   (0)	// 0:Ч
#define PROFILE_FOLLOW_MASTER_AXIS_PRF     (1)	// 1:AXIS滮ֵ
#define PROFILE_FOLLOW_MASTER_AXIS_ENC     (2)	// 2AXISֵ
#define PROFILE_FOLLOW_MASTER_ENC          (3)	// 3ֵ

// FOLLOW
// axisHandle
// masterNo  кţ0~N
// masterType    궨
MTN_API short  __stdcall NMC_MtFollowSetMaster(HAND axisHandle,short masterNo,short masterType);

// ȡFOLLOW
// axisHandle
// pMasterNo  кţ0~N
// pMasterType    궨
MTN_API short  __stdcall NMC_MtFollowGetMaster(HAND axisHandle,short *pMasterNo,short *pMasterType);

// FOLLOWѭִд
// loopCntѭ
MTN_API short  __stdcall NMC_MtFollowSetLoopCount(HAND axisHandle,Int32 loopCnt);

// ȡFOLLOWѭִд
// pLoopCntѭ
MTN_API short  __stdcall NMC_MtFollowGetLoopCount(HAND axisHandle,Int32 *pLoopCnt);

// FOLLOW¼
#define PROFILE_FOLLOW_EVENT_START        (1)	// 
#define PROFILE_FOLLOW_EVENT_PASS         (2)	// ᴩԽ趨λԺ

// FOLLOWĵ¼
// eventType1 ʾָԺ	2ʾ	ᴩԽ趨λԺ
// masterDir:Խʱ˶1 ˶-1 Ḻ˶
// pos:Խλ
MTN_API short  __stdcall NMC_MtFollowSetEvent(HAND axisHandle,short eventType,short masterDir,Int32 pos);

// ȡFOLLOW¼
// pEvent1 ʾָԺ2ʾᴩԽ趨λԺ
// pMasterDir:Խʱ˶1 ˶-1 Ḻ˶
// pPos:Խλ
MTN_API short  __stdcall NMC_MtFollowGetEvent(HAND axisHandle,short *pEvent,short *pMasterDir,Int32 *pPos);

// ȡFOLLOWfifoʣռ
// pSpaceռС
// fifoNo:fifoţ01
MTN_API short  __stdcall NMC_MtFollowGetSpace(HAND axisHandle,short *pSpace,short fifoNo);

// FOLLOWĶ
#define PROFILE_FOLLOW_SEGMENT_NORMAL   	 (0)	// 0ͨ
#define PROFILE_FOLLOW_SEGMENT_EVEN     	 (1)	// 1ٶ
#define PROFILE_FOLLOW_SEGMENT_STOP     	 (2)	// 2ֹͣ
#define PROFILE_FOLLOW_SEGMENT_CONTINUE 	 (3)	// 3

// FOLLOW
// masterPosλ
// slavePos:λ
// type:ݶͣ0ͨΣĬϣ1ٶΣ2 ٵ 0 Σ3 FIFO ֮ٶ
// fifoNo:fifoţ01
MTN_API short  __stdcall NMC_MtFollowPushData(HAND axisHandle,Int32 masterPos,double slavePos,short type,short fifoNo);

// FOLLOWӦfifoŵ
// fifoNo:fifoţ01
MTN_API short  __stdcall NMC_MtFollowClear(HAND axisHandle,short fifoNo);

// Follow˶
// syncCount axisHandle ͬ
// pSyncAxisArray: ͬţ0~N
MTN_API short  __stdcall NMC_MtFollowStart(HAND axisHandle,short syncAxCnts,short *pSyncAxArray);

// лFollow˶fifo
// syncCount axisHandle ͬfifoл
// pSyncAxisArray: ͬfifoлţ0~N
MTN_API short  __stdcall NMC_MtFollowSwitch(HAND axisHandle,short syncAxCnts,short *pSyncAxArray);


#ifdef __cplusplus
}
#endif


#endif  // _H_NMC_LIB20_H_
