////**********************************************************************************************************
//
//  Copyright(c) 2017, Shenzhen Gaochuan Industrial Automation Co.,Ltd
//
//  Moudle Name :   nio_lib20.h
//
//  Abstract    :   GaoChuan IO 2.0 User Header
//
//  Note        :   
// Modification History :
////**********************************************************************************************************
#ifndef _H_NIO_LIB20_H_
#define _H_NIO_LIB20_H_

#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------------------------------------
//
//              궨
//
//------------------------------------------------------------------------------------------------------------
// 
#ifndef NIO_API
    #ifdef WIN32 
        #ifdef NIO_LIB_EXPORTS
            #define NIO_API __declspec(dllexport)
        #else
            #define NIO_API 
        #endif
    #else
        #define NIO_API 
        #define __stdcall 
    #endif    
#endif


// ׼Ͷ
typedef unsigned char  U8;
typedef short          I16;
typedef unsigned short U16;
typedef long           I32;
typedef unsigned long  U32;
typedef float          F32;
typedef double         F64;

// Ͷ
typedef     unsigned short*     PHAND;
typedef     unsigned short      HAND;

//------------------------------------------------------------------------------------------------------------
//
//           ָ
//
//------------------------------------------------------------------------------------------------------------
//	1.豸򿪵
//	2.
//	3.
//	4.жϴ
//------------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------------
//
//	1.豸򿪵
//
//------------------------------------------------------------------------------------------------------------
//豸Ϣṹ
typedef struct
{
    I16 address;			// ϵĲַ
	I16 diNum;				// Դ
	I16 doNum;				// Դ
	I16 adNum;				// Դģ
	I16 daNum;				// Դģ
	I16 intNum;				// Դж
	I16 encNum;				// Դ
    I16 resource[17];       // Դб
}TIODevInfo;

// 忨Ѱ
// : mode:ͨѶģʽ
// pDevNum : 豸Ŀ
// pInfoList豸Ϣ
NIO_API I16 __stdcall NIO_DevSearch( I16 mode, I16 *pDevNum, TIODevInfo *pInfoList );

// 忨򿪣ţ
// devNo: 豸,ȡֵΧ[0,n] pDevHandle: 豸
NIO_API I16 __stdcall NIO_DevOpen ( I16 devNo, PHAND pDevHandle );

// 忨򿪣ݲַ
NIO_API I16 __stdcall NIO_DevOpenByAddress ( I16 addr, PHAND pDevHandle );

// ȡϢ
// pCardInfo:Ϣ
NIO_API I16 __stdcall NIO_DevGetInfo ( HAND devHandle, TIODevInfo *pCardInfo );

// λ״̬
NIO_API I16 __stdcall NIO_DevReset ( HAND devHandle);

//------------------------------------------------------------------------------------------------------------
//
//	2.
//
//------------------------------------------------------------------------------------------------------------
// ȡֵ32λ
// offset:ƫƣȡֵΧ[0,1],0ʾȡdi0~di311ʾȡdi32~di63
// pValue:ȡֵλʾ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DIGet32Bit(HAND devHandle,I16 offset,I32 *pValue);

// ȡֵ16λ
// offset:ƫƣȡֵΧ[0,3],0ʾȡdi0~di151ʾȡdi16~di31
// pValue:ȡֵλʾ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DIGet16Bit(HAND devHandle,I16 offset,I16 *pValue);

// ȡֵ1λ
// offset:ƫƣȡֵΧ[0,63] 
// pValue:ȡֵ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DIGetBit(HAND devHandle,I16 offset,I16 *pValue);

// ֵ߼ȡ粻
// offset:ƫƣȡֵΧ[0,63] 
// revs:Ƿȡ0ʾȡĬϣ 1ʾȡ
NIO_API I16 __stdcall NIO_DISetBitRevs(HAND devHandle,I16 offset,I16 revs);

// ȡֵ߼ȡֵ
NIO_API I16 __stdcall NIO_DIGetBitRevs(HAND devHandle,I16 offset,I16 *pRevs);

//------------------------------------------------------------------------------------------------------------
//
//	3.
//
//------------------------------------------------------------------------------------------------------------
// ֵ32λ
// offset:ƫƣȡֵΧ[0,1],0ʾȡdo0~do311ʾȡdo32~do63
// val:ֵλʾ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DOSet32Bit(HAND devHandle,I16 offset,I32 val);

// ֵ16λ
// offset:ƫƣȡֵΧ[0,3],0ʾȡdo0~do151ʾȡdo16~do31
// val:ֵλʾ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DOSet16Bit(HAND devHandle,I16 offset,I16 val);

// ֵ1λ
// offset:ƫƣȡֵΧ[0,63] 
// val:ֵ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DOSetBit(HAND devHandle,I16 offset,I16 val);

// ȡֵ32λ
// offset:ƫƣȡֵΧ[0,1],0ʾȡdo0~do311ʾȡdo32~do63
// pValue:ȡֵλʾ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DOGet32Bit(HAND devHandle,I16 offset,I32 *pValue);

// ȡֵ16λ
// offset:ƫƣȡֵΧ[0,3],0ʾȡdo0~do151ʾȡdo16~do31
// pValue:ȡֵλʾ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DOGet16Bit(HAND devHandle,I16 offset,I16 *pValue);

// ȡֵ1λ
// offset:ƫƣȡֵΧ[0,63] 
// pValue:ȡֵ0ʾ͵ƽ 1ʾߵƽ
NIO_API I16 __stdcall NIO_DOGetBit(HAND devHandle,I16 offset,I16 *pValue);

// ֵ߼ȡ粻
// offset:ƫƣȡֵΧ[0,63] 
// revs:Ƿȡ0ʾȡĬϣ 1ʾȡ
NIO_API I16 __stdcall NIO_DOSetBitRevs(HAND devHandle,I16 offset,I16 revs);

// ȡֵ߼ȡֵ
NIO_API I16 __stdcall NIO_DOGetBitRevs(HAND devHandle,I16 offset,I16 *pRevs);


NIO_API I16 __stdcall NIO_DevEnable (HAND devHandle);

// PCIe豸ȡ
// devIndex:豸ţȡֵ[0,n]
// cardType:豸ͣ0˶ƿ  1IO
// dataLen:ȡݳȣλ:Byte
// buff:
NIO_API I16 __stdcall NIO_ReadEEPROMData(I16 devIndex,I16 cardType,I16 dataLen,void *buff);

//------------------------------------------------------------------------------------------------------------
//
//	4.жϴ
//
//------------------------------------------------------------------------------------------------------------
//жϻصָ붨
typedef void (*GCNIO_IntCallback)(void);

// ж
// idx	  : жţȡֵΧ[0,1]
// sns	  : жϴƽ: 0½ 1
// autoClr: жϴǷԶ־λ
// onOff  : ־λ0:ر 1: 2:״̬
NIO_API I16 __stdcall NIO_IntConfig(HAND devHandle,I16 idx,I16 sns,I16 autoClr,I16 onOff,GCNIO_IntCallback pCallback);

// жжϴҪܽһж
// idx	  : жţȡֵΧ[0,1]
NIO_API I16 __stdcall NIO_IntClr(HAND devHandle,I16 idx);

// жϵĴ
// idx	  : жţȡֵΧ[0,1]
NIO_API I16 __stdcall NIO_IntZeroTrigCnt(HAND devHandle,I16 idx);

// ж
// idx	  : жţȡֵΧ[0,1]
NIO_API I16 __stdcall NIO_IntPreSet(HAND devHandle,I16 idx);

// ȡж״̬
// idx	  : жţȡֵΧ[0,1]
// pTrigCnt	  : жϴ
// pOnOff  : жϵĿ״̬0:ر 1: 2:״̬
NIO_API I16 __stdcall NIO_IntGetSts(HAND devHandle,I16 idx,I32 *pTrigCnt,I16 *pOnOff);



// ģ


// ģ





#ifdef __cplusplus
}
#endif


#endif  // _H_NIO_LIB20_H_
