﻿////*****************************************************************
//
// Moudle Name  :   nmc_lib20.h
// Abstract     :   GaoChuan Motion 2.0 user header
// Modification History :
// Note :			1.结构体定义中所有的‘dummyxxx’的成员都是保留参数，请不要修改他们
//					2.无特别说明，所有API返回RTN_CMD_SUCCESS（即0值）表示执行成功，其他则表示错误代码
//					3.所有的API参数中，无特别说明，axisHandle表示操作轴的句柄，devHandle表示目标控制器的句柄，crdHandle表示目标坐标系组句柄
////*****************************************************************
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

using HAND = System.UInt16;

namespace GC.NIO
{
    //中断回调函数指针定义
   public delegate void GCNIO_InterruptHandlerDelegate();

    public class CNioLib20
    {
        public const string DLL_PATH = @"nio_lib20.dll";

        //设备信息结构
        public struct TIODevInfo
        {
            public Int16 address;			// 板上的拨码地址
            public Int16 diNum;				// 资源数量：数字量输入
            public Int16 doNum;				// 资源数量：数字量输出
            public Int16 adNum;				// 资源数量：模拟量输入
            public Int16 daNum;				// 资源数量：模拟量输出
            public Int16 intNum;			// 资源数量：中断数量
            public Int16 encNum;			// 资源数量：编码器数量

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
            public Int16[] resource;
            /*public Int16 resource0;       // 资源列表
            public Int16 resource1;       // 资源列表
            public Int16 resource2;       // 资源列表
            public Int16 resource3;       // 资源列表
            public Int16 resource4;       // 资源列表
            public Int16 resource5;       // 资源列表
            public Int16 resource6;       // 资源列表
            public Int16 resource7;       // 资源列表

            public Int16 resource8;       // 资源列表
            public Int16 resource9;       // 资源列表
            public Int16 resource10;       // 资源列表
            public Int16 resource11;       // 资源列表
            public Int16 resource12;       // 资源列表
            public Int16 resource13;       // 资源列表
            public Int16 resource14;       // 资源列表
            public Int16 resource15;       // 资源列表*/

            public TIODevInfo(bool bInit)
            {
                address = 0;
                ID = 0;
                diNum = 0;
                doNum = 0;
                adNum = 0;
                daNum = 0;
                intNum = 0;
                encNum = 0;

                resource = new short[16];
                //resource0 = resource1 = resource2 = resource3 = 0;
                //resource4 = resource5 = resource6 = resource7 = 0;
                //resource8 = resource9 = resource10 = resource11 = 0;
                //resource12 = resource13 = resource14 = resource15 = 0;
            }
        };

        // 板卡搜寻
        // 参数: mode:通讯模式
        // pDevNum : 返回设备的数目
        // pInfoList：返回设备信息
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DevSearch(Int16 mode, ref Int16 pDevNum,
            [MarshalAs(UnmanagedType.LPArray, SizeConst = 8*24)] Int16[] pInfoList);

        // 板卡打开（根据序号）
        // devNo: 设备序号,取值范围[0,n]； pDevHandle: 返回设备操作句柄
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DevOpen(Int16 devNo, ref HAND pDevHandle);

        // 板卡打开（根据拨码地址）
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DevOpenByAddress(Int16 addr, ref HAND pDevHandle);

        // 获取卡信息
        // pCardInfo:信息
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DevGetInfo(HAND devHandle, ref TIODevInfo pCardInfo);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DevReset(HAND devHandle);
        // 获取错误代码信息
        // errCode:错误代码
        // errDesc:返回的错误代码描述
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_GetErrDesc(short errCode, ref string errDesc);


        // 数字量输入
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DIGet32Bit(HAND devHandle, Int16 offset, ref Int32 pValue);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DIGet16Bit(HAND devHandle, Int16 offset, ref Int16 pValue);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DIGetBit(HAND devHandle, Int16 offset, ref Int16 pValue);


        // 数字量输出
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DOSet32Bit(HAND devHandle, Int16 offset, Int32 val);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DOSet16Bit(HAND devHandle, Int16 offset, Int16 val);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DOSetBit(HAND devHandle, Int16 offset, Int16 val);

        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DOGet32Bit(HAND devHandle, Int16 offset, ref Int32 pValue);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DOGet16Bit(HAND devHandle, Int16 offset, ref Int16 pValue);
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_DOGetBit(HAND devHandle, Int16 offset, ref Int16 pValue);

        // 中断
        // 设置中断
        // idx	  : 中断序号，取值范围[0,1]
        // sns	  : 中断触发电平: 0下降沿 1上升沿
        // onOff  : 操作标志位，0:关闭 1:打开 2:清除状态
        // autoClr: 中断触发后是否自动清除标志位
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
                public static extern Int16 NIO_IntConfig(HAND devHandle, Int16 idx, Int16 sns, Int16 autoClr, Int16 onOff, GCNIO_InterruptHandlerDelegate pCallback);

        // 中断清除，中断触发后，需要清除才能接收下一次中断
        // idx	  : 中断序号，取值范围[0,1]
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_IntClr(HAND devHandle, Int16 idx);
        
        // 中断软触发
				// idx	  : 中断序号，取值范围[0,1]
				[DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_IntPreSet(HAND devHandle, Int16 idx);
        
        // 读取中断状态
        // idx	  : 中断序号，取值范围[0,1]
        // pTrigCnt	  : 中断触发计数
        // pOnOff  : 中断的开关状态，0:关闭 1:打开 2:清除状态
        [DllImport(DLL_PATH, CallingConvention = CallingConvention.StdCall)]
        public static extern Int16 NIO_IntGetSts(HAND devHandle, Int16 idx, ref Int32 pTrigCnt, ref Int16 pOnOff);

    }

}