////**********************************************************************************************************
//
//  Copyright(c) 2017, Shenzhen Gaochuan Industrial Automation Co.,Ltd
//
//  Moudle Name :   nio_lib20.h
//
//  Abstract    :   GaoChuan IO 2.0 User Header
//
//  Note        :   
// Modification History :
////**********************************************************************************************************
#ifndef _H_NIO_LIB20_H_
#define _H_NIO_LIB20_H_

#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------------------------------------
//
//              궨
//
//------------------------------------------------------------------------------------------------------------
// 
#ifndef NIO_API
    #ifdef WIN32 
        #ifdef NIO_LIB_EXPORTS
            #define NIO_API __declspec(dllexport)
        #else
            #define NIO_API 
        #endif
    #else
        #define NIO_API 
        #define __stdcall 
    #endif    
#endif


// ׼Ͷ
typedef unsigned char  U8;
typedef short          I16;
typedef unsigned short U16;
typedef long           I32;
typedef unsigned long  U32;
typedef float          F32;
typedef double         F64;

// Ͷ
typedef     unsigned short*     PHAND;
typedef     unsigned short      HAND;


//豸Ϣṹ
typedef struct
{
    I16 address;			// ϵĲַ
	I16 diNum;				// Դ
	I16 doNum;				// Դ
	I16 adNum;				// Դģ
	I16 daNum;				// Դģ
	I16 intNum;				// Դж
	I16 encNum;				// Դ
    I16 resource[17];       // Դб
}TIODevInfo;

// 忨Ѱ
// : mode:ͨѶģʽ
// pDevNum : 豸Ŀ
// pInfoList豸Ϣ
NIO_API I16 __stdcall NIO_DevSearch( I16 mode, I16 *pDevNum, TIODevInfo *pInfoList );

// 忨򿪣ţ
// devNo: 豸,ȡֵΧ[0,n] pDevHandle: 豸
NIO_API I16 __stdcall NIO_DevOpen ( I16 devNo, PHAND pDevHandle );

// 忨򿪣ݲַ
NIO_API I16 __stdcall NIO_DevOpenByAddress ( I16 addr, PHAND pDevHandle );

// ȡϢ
// pCardInfo:Ϣ
NIO_API I16 __stdcall NIO_DevGetInfo ( HAND devHandle, TIODevInfo *pCardInfo );
NIO_API I16 __stdcall NIO_DevReset ( HAND devHandle);
// ȡϢ
// errCode:
// errDesc:صĴ
NIO_API short  __stdcall NIO_GetErrDesc( short errCode,char *errDesc);


// 
NIO_API I16 __stdcall NIO_DIGet32Bit(HAND devHandle,I16 offset,I32 *pValue);
NIO_API I16 __stdcall NIO_DIGet16Bit(HAND devHandle,I16 offset,I16 *pValue);
NIO_API I16 __stdcall NIO_DIGetBit(HAND devHandle,I16 offset,I16 *pValue);


// 
NIO_API I16 __stdcall NIO_DOSet32Bit(HAND devHandle,I16 offset,I32 val);
NIO_API I16 __stdcall NIO_DOSet16Bit(HAND devHandle,I16 offset,I16 val);
NIO_API I16 __stdcall NIO_DOSetBit(HAND devHandle,I16 offset,I16 val);

NIO_API I16 __stdcall NIO_DOGet32Bit(HAND devHandle,I16 offset,I32 *pValue);
NIO_API I16 __stdcall NIO_DOGet16Bit(HAND devHandle,I16 offset,I16 *pValue);
NIO_API I16 __stdcall NIO_DOGetBit(HAND devHandle,I16 offset,I16 *pValue);


// -----------------------------------------------------------------ж
//жϻصָ붨
typedef void (*GCNIO_IntCallback)(void);

// ж
// idx	  : жţȡֵΧ[0,1]
// sns	  : жϴƽ: 0½ 1
// autoClr: жϴǷԶ־λ
// onOff  : ־λ0:ر 1: 2:״̬
NIO_API I16 __stdcall NIO_IntConfig(HAND devHandle,I16 idx,I16 sns,I16 autoClr,I16 onOff,GCNIO_IntCallback pCallback);

// жжϴҪܽһж
// idx	  : жţȡֵΧ[0,1]
NIO_API I16 __stdcall NIO_IntClr(HAND devHandle,I16 idx);

// ж
// idx	  : жţȡֵΧ[0,1]
NIO_API I16 __stdcall NIO_IntPreSet(HAND devHandle,I16 idx);

// ȡж״̬
// idx	  : жţȡֵΧ[0,1]
// pTrigCnt	  : жϴ
// pOnOff  : жϵĿ״̬0:ر 1: 2:״̬
NIO_API I16 __stdcall NIO_IntGetSts(HAND devHandle,I16 idx,I32 *pTrigCnt,I16 *pOnOff);

// ģ


// ģ





#ifdef __cplusplus
}
#endif


#endif  // _H_NIO_LIB20_H_
