﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using GC.NIO;

namespace nio_exam
{
    public partial class FormMain : Form
    {
        UInt16 m_hDev;
        
        public FormMain()
        {
            InitializeComponent();

            comboBoxIntList.Items.Clear();
            comboBoxIntList.Items.Add("0");
            comboBoxIntList.Items.Add("1");
            comboBoxIntList.SelectedIndex = 0;

        }

        private void buttonConnect_Click(object sender, EventArgs e)
        {
            short rtn;
            short devCnt = 0;
            int idx = 0,offset,devIdx;
            short[] infArry = new short[8 * 24];
            CNioLib20.TIODevInfo[] devList = new CNioLib20.TIODevInfo[8];
            for (Int16 i = 0; i < 8; i++)
            {
                devList[i] = new CNioLib20.TIODevInfo(true);
            }

            rtn = CNioLib20.NIO_DevSearch(0, ref devCnt, infArry);
            if (rtn != 0)
            {
                AddMsg(true, "DevSearch error");
            }
            else
            {
                if (devCnt > 0)
                {
                    idx = 0;
                    offset = 0;
                    devIdx = 0;
                    devList[devIdx].address = infArry[offset + idx]; idx++;
                    devList[devIdx].ID = infArry[offset + idx]; idx++;
                    devList[devIdx].diNum = infArry[offset + idx]; idx++;
                    devList[devIdx].doNum = infArry[offset + idx]; idx++;
                    devList[devIdx].adNum = infArry[offset + idx]; idx++;
                    devList[devIdx].daNum = infArry[offset + idx]; idx++;
                    devList[devIdx].intNum = infArry[offset + idx]; idx++;
                    devList[devIdx].encNum = infArry[offset + idx]; idx++;
                    AddMsg(false,"GC_IOCard." + devIdx.ToString() + ": address=" + devList[devIdx].address.ToString());


                    rtn = CNioLib20.NIO_DevOpen(0, ref m_hDev);
                    if (rtn == 0)
                    {
                        groupBoxIO.Enabled = true;
                        groupBoxINT.Enabled = true;
                        timer1.Enabled = true;
                        AddMsg(false, "NIO_DevOpen ok");
                    }
                }
            }
        }

        private void buttonSet_Click(object sender, EventArgs e)
        {
            short group = Convert.ToInt16(comboBox1.SelectedIndex);
            short val = Convert.ToInt16(numericUpDown1.Value);
            short rtn;

            rtn = CNioLib20.NIO_DOSet16Bit(m_hDev, group, val);
            if (rtn != 0)
            {
                AddMsg(true, "NIO_DOSet16Bit err");
            }

        }

        private void AddMsg(bool bErr, string msg)
        {
            if (bErr)
            {
                listBoxLog.Items.Add("err:" + msg);
            }
            else
            {
                listBoxLog.Items.Add("inf:" + msg);
            }
            
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            short[] diVal = new short[4];
            short[] doVal = new short[4];

            for (int i = 0; i < 4; i++)
            {
                CNioLib20.NIO_DOGet16Bit(m_hDev, Convert.ToInt16(i), ref doVal[i]);
                CNioLib20.NIO_DIGet16Bit(m_hDev, Convert.ToInt16(i), ref diVal[i]);
            }

            textBoxDI.Text = string.Format("0x{0:X} 0x{0:X} 0x{0:X} 0x{0:X} ", diVal[0], diVal[1], diVal[2], diVal[3]);
            textBoxDO.Text = string.Format("0x{0:X} 0x{0:X} 0x{0:X} 0x{0:X} ", doVal[0], doVal[1], doVal[2], doVal[3]);


            // 中断状态
            short intOnoff = 0;
            Int32 intTrigCnt = 0;

            CNioLib20.NIO_IntGetSts(m_hDev, 0, ref intTrigCnt, ref intOnoff);
            labelIntOnOff0.Text = intOnoff.ToString();
            labelIntCnt0.Text = intTrigCnt.ToString();

            CNioLib20.NIO_IntGetSts(m_hDev, 1, ref intTrigCnt, ref intOnoff);
            labelIntOnOff1.Text = intOnoff.ToString();
            labelIntCnt1.Text = intTrigCnt.ToString();

        }

        public void Interrput1Handler()
        {
            AddMsg(false, "Interrupt1 trig ...");
            CNioLib20.NIO_IntClr(m_hDev, 0);
        }

        public void Interrput2Handler()
        {
            AddMsg(false, "Interrupt2 trig ...");
            CNioLib20.NIO_IntClr(m_hDev, 1);
        }

        private void buttonOpen_Click(object sender, EventArgs e)
        {
            short rtn;
            int interIdx = comboBoxIntList.SelectedIndex;
            if (interIdx == 0)
            {
                rtn = CNioLib20.NIO_IntConfig(m_hDev, Convert.ToInt16(interIdx), 0, 0, 1, (GCNIO_InterruptHandlerDelegate)Interrput1Handler);
            }
            else
            {
                rtn = CNioLib20.NIO_IntConfig(m_hDev, Convert.ToInt16(interIdx), 0, 0, 1, (GCNIO_InterruptHandlerDelegate)Interrput2Handler);
            }
            if (rtn != 0)
            {
                AddMsg(true, "Interrupt配置出错 = " + rtn.ToString());
            }
            else
            {
                rtn = CNioLib20.NIO_IntClr(m_hDev, Convert.ToInt16(interIdx));
                if (rtn != 0)
                {
                    AddMsg(true, "Interrupt清除出错 = " + rtn.ToString());
                }
            }
        }

        private void buttonClose_Click(object sender, EventArgs e)
        {
            short rtn;
            int interIdx = comboBoxIntList.SelectedIndex;
            rtn = CNioLib20.NIO_IntConfig(m_hDev, Convert.ToInt16(interIdx), 0, 0, 0, (GCNIO_InterruptHandlerDelegate)Interrput1Handler);
            if (rtn != 0)
            {
                AddMsg(true, "Interrupt关闭出错 = " + rtn.ToString());
            }
        }

        private void buttonClr_Click(object sender, EventArgs e)
        {
            short rtn;
            int interIdx = comboBoxIntList.SelectedIndex;

            rtn = CNioLib20.NIO_IntClr(m_hDev, Convert.ToInt16(interIdx));
            if (rtn != 0)
            {
                AddMsg(true, "Interrupt清除出错 = " + rtn.ToString());
            }
        }
    }
}
